/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.push.EMPushConfig;

/**
 * \~chinese
 * 提供SDK聊天相关的设置
 * 用户可以用来配置SDK的各种参数，选项
 * 比如，发送消息加密，是否自动接受加好友邀请
 * 
 * \~english
 * Settings for chat of SDK
 * You can set parameters and options of SDK
 * Such as: send encrypted messages, whether automatically accept friend invitations
 */
public class EMOptions {

	/**
	 * \~chinese
	 * 是否自动接受加好友邀请
	 *
	 * \~english
	 * whether accept friend invitation for user automatically
	 */
	private boolean acceptInvitationAlways = true;
	
	/**
	 * \~chinese
	 * 是否自动接受群组邀请
	 *
	 * \~english
	 * whether accept group invitation automatically
	 */
	private boolean autoAcceptGroupInvitation = true;
	
	/**
	 * \~chinese
	 * 是否对发送消息进行加密
	 *
	 * \~english
	 * whether encrypt the messages
	 */
	private boolean useEncryption = false;

	/**
	 * \~chinese
	 * 是否需要消息接受方已读确认，缺省true
	 *
	 * \~english
	 * whether receive message read by receiving user event
	 */
	private boolean requireReadAck = true;
	
	/**
	 * \~chinese
	 * 是否需要消息接收方送达确认，缺省false
	 *
	 * \~english
	 * whether receive message delivered to server event
	 */
	private boolean requireDeliveryAck = false;
	
	private boolean deleteMessagesAsExitGroup = true;
	
	private boolean isChatroomOwnerLeaveAllowed = true;

	/**
	 * \~chinese
	 * 离开聊天室是否删除消息，缺省true
	 *
	 * \~english
	 * whether delete chat room message after existing the chat room
	 */
	private boolean deleteMessagesAsExitChatRoom = true;
	
	private String appkey = "";
	
	private EMChatConfigPrivate config = null;
	
	private boolean enableAutoLogin = true;
	
	private String fcmNumber = null;
	private boolean useFCM = true;
	private EMChatConfigPrivate.EMMipushConfig mipushConfig = null;

	private boolean enableDNSConfig = true;
	
	private boolean sortMessageByServerTime = true;

	private boolean useHttps = false;
	private String dnsUrl = "";

	private String restServer;
	private String reportServer;
	private String imServer;
	private int imPort;

	private boolean usingHttpsOnly = false;
	private boolean serverTransfer = true;
	private boolean isAutodownload = true;
	private boolean useStereoInput = false;
	private boolean enableStatistics = true;
	private boolean enableUseRtcConfig = false;
	private String  rtcConfigUrl;
	private EMPushConfig pushConfig;

	/**
	 * \~chinese
	 * 获取已读确认设置，缺省值为true
	 * 如果设为true，会要求消息的接受方发送已读回执。
	 *
	 * @return 是否要求消息的接收方发送已读回执
	 * 
	 * \~english
	 * Get whether read ack is required for the message receiver, default is true
	 * If set to true, need message receiver to send read ack
	 *
	 * @return Whether read ack is required
	 */
	public boolean getRequireAck() {
		
		if(config == null){
			return requireReadAck;
		}
		return  config.getRequireReadAck();
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方已读确认
	 *
	 * @param requireAck 是否需要已读回执
	 * 
	 * \~english
	 * Enable/disable the read ack of receipt
	 *
	 * @param requireAck Whether read ack is required
	 */
	public void setRequireAck(boolean requireAck) {
		this.requireReadAck = requireAck;

		if (config == null) {
			return;
		}
		config.setRequireReadAck(requireAck);
	}
	
	/**
	 * \~chinese
	 * 获取送达确认设置，缺省值为false
	 * 如果设为true，会要求消息的接受方发送送达回执
	 * 
	 * @return 是否需要送达回执
	 * 
	 * \~english
	 * Get whether delivery ack is required
	 * If set to true, need message receiver to send delivery ack
	 *
	 * @return Whether delivery ack is required
	 */
	public boolean getRequireDeliveryAck() {
		if (config == null) {
			return requireDeliveryAck;
		}
		return config.getRequireDeliveryAck();
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方送达确认,默认false
	 *
	 * @param requireDeliveryAck 是否需要送达确认
	 * 
	 * \~english
	 * Enable/disable deliver ack
	 *
	 * @param requireDeliveryAck Whether delivery ack is required
	 */
	public void setRequireDeliveryAck(boolean requireDeliveryAck) {
		this.requireDeliveryAck = requireDeliveryAck;
		
		if (config == null) {
			return;
		}
		config.setRequireDeliveryAck(requireDeliveryAck);
	}

	/**
	 * \~chinese
	 * 获取是否自动接受加好友邀请，缺省值为true
	 * 
	 * @return 是否自动接受加好友邀请
	 * 
	 * \~english
	 * Get if accept the other's invitation to be your friend automatically, default is true
	 *
	 * @return Whether accept invitation automatically
	 */
	public boolean getAcceptInvitationAlways() {
		if (config == null) {
			return acceptInvitationAlways;
		}
		return config.getAutoAccept();
	}

	/**
	 * \~chinese
	 * 设置是否自动接受加好友邀请
	 *
	 * @param value 是否自动接受加好友邀请
	 * 
	 * \~english
	 * enable/disable accept the friend invitation automatically
	 * @param value Whether accept invitation automatically
	 */
	public void setAcceptInvitationAlways(boolean value) {
		if (config == null) {
			acceptInvitationAlways = value;
			return;
		}
		config.setAutoAccept(value);
	}

	/**
	 * \~chinese
     * 设置退出(主动和被动退出)群组时是否删除聊天消息
	 *
     * @param delete True为删除群组相关消息，默认值为true
     * 
     * \~english
	 * Enable/disable deleting the group message after existing the group
	 *
     * @param delete If set to True, delete the messages, default is true
     */
    public void setDeleteMessagesAsExitGroup(boolean delete){
		if (config == null) {
			deleteMessagesAsExitGroup = delete;
			return;
		}
		
		config.setDeleteMessageAsExitGroup(delete);
    }
    
    /**
	 * \~chinese
     * 获取退出(主动和被动退出)群组时是否删除聊天消息
     * @return  true为删除群组相关消息
     * 
     * \~english
	 * Get whether to delete the group message after existing a group
     * @return True: delete the messages
     */
    public boolean isDeleteMessagesAsExitGroup() {
		if (config == null) {
			return deleteMessagesAsExitGroup;
		}
		
		return config.getDeleteMessageAsExitGroup();

    }
    
    /**
     * \~chinese
     * 设置是否自动接受加群邀请
     * @param value
     * 
     * \~english
     * Set whether to accept group invitation automatically
     * @param value
     */
    public void setAutoAcceptGroupInvitation(boolean value) {
        if (config == null) {
            autoAcceptGroupInvitation = value;
            return;
        }
        config.setAutoAcceptGroupInvitation(value);
    }
    
    /**
     * \~chinese
     * 获取是否自动接受加群邀请
     * @return 返回是否自动接受加群邀请
     * 
     * \~english
     * Get whether to accept group invitation automatically
     * @return	Return the result whether to accept group invitation automatically
     */
    public boolean isAutoAcceptGroupInvitation() {
        if (config == null) {
            return autoAcceptGroupInvitation;
        }
        return config.isAutoAcceptGroupInvitation();
    }

	/**
	 * \~chinese
	 * 设置是否允许聊天室owner离开并删除会话记录
	 * 设置为true后owner不再接受任何消息
	 * @param allowed 是否允许聊天室owner离开
	 * 
	 * \~english
	 * Enable/disable allowing chat room owner to leave the chat room
	 * @param allowed Whether to allow the owner of chat room to leave
	 */
    public void allowChatroomOwnerLeave(boolean allowed){
		if (config == null) {
			this.isChatroomOwnerLeaveAllowed = allowed;
			return;
		}
		
		config.setIsChatroomOwnerLeaveAllowed(allowed);
	}
	
	/**
	 * \~chinese
	 * 获取是否允许聊天室owner离开
	 * @return true：离开并不保留会话记录；false：离开保留会话记录
	 * 
	 * \~english
	 * Get whether to allow owner of chat room to leave
	 * @return True: when leave do not keep conversation; False: when leave do keep conversation
	 */
	public boolean isChatroomOwnerLeaveAllowed(){
		if (config == null) {
			return isChatroomOwnerLeaveAllowed;
		}
		return config.getIsChatroomOwnerLeaveAllowed();
	}

	/**
	 * \~chinese
	 * 设置退出(主动和被动退出)聊天室时是否删除聊天消息
	 * @param delete true为删除聊天室相关消息记录
	 *
	 * \~english
	 * Enable/disable deleting the chat room message after existing the chat room
	 * @param delete True means to delete the chat room related message record
	 */
	public void setDeleteMessagesAsExitChatRoom(boolean delete){
		if (config == null) {
			deleteMessagesAsExitChatRoom = delete;
			return;
		}

		config.setDeleteMessageAsExitChatRoom(delete);
	}

	/**
	 * \~chinese
	 * 获取退出(主动和被动退出)聊天室时是否删除聊天消息
	 * @return  返回true表示删除群组相关消息记录，默认为true
	 *
	 * \~english
	 * Get whether to  delete the chat room message after existing the chat room
	 * @return Return true means to delete the chat room related message record, default is true
	 */
	public boolean isDeleteMessagesAsExitChatRoom() {
		if (config == null) {
			return deleteMessagesAsExitChatRoom;
		}

		return config.getDeleteMessageAsExitChatRoom();

	}
	
	 
	/**
	 * \~chinese
	 * 是否按照服务器收到时间进行排序，默认是false
	 * @return 返回是否按照服务器收到的时间排序
	 * 
	 * \~english
	 * Get Whether sort messages by server received time, default is false
	 * @return Return the result whether sort message by server received time
	 */
    public boolean isSortMessageByServerTime() {
        if (config == null) {
            return sortMessageByServerTime;
        }
        return config.getSortMessageByServerTime();
    }

	/**
	 * \~chinese
	 * 设置是否按照服务器收到的时间对消息进行排序
	 * @param sortByServerTime
	 *
	 * \~english
	 * Enable/disable setting to sort messages by server received time
	 * @param sortByServerTime
	 */
	public void setSortMessageByServerTime(boolean sortByServerTime) {
        if (config == null) {
            this.sortMessageByServerTime = sortByServerTime;
            return;
        }
        
        config.setSortMessageByServerTime(sortByServerTime);
    }
	
	/**
	 * \~chinese
	 * 设置appkey
	 * @param appkey
	 * 
	 * \~english
	 * set app key
	 * @param appkey
	 */
	void updatePath(String appkey){
		if(config != null) {
            config.updatePath(appkey);
		}
	}

	/**
	 * \~chinese
	 * 设置appkey
	 * @param appkey
	 *
	 * \~english
	 * Set app key
	 * @param appkey
	 */
	public void setAppKey(String appkey) {
		this.appkey = appkey;
		updatePath(appkey);
	}
	
	/**
	 * \~chinese
	 * 获取appkey
	 *
	 * \~english
	 * Get app key
	 */
	public String getAppKey(){
		if(config == null){
			return appkey;
		}
		
		return config.getAppKey();
	}

	/**
	 * \~chinese
	 * 设置im服务器地址
	 * @param imServer
	 *
	 * \~english
	 * Set the custom im server
	 * @param imServer
     */
	public void setIMServer(String imServer){
		if(imServer == null){
			return;
		}

		this.imServer = imServer;
		if(config == null){
			return;
		}
		config.setChatServer(imServer);
	}

	/**
	 * \~chinese
	 * 获取设置的im 服务器地址
	 * @return im服务器地址
	 *
	 * \~english
	 * Get the im server
	 * @return im server url
	 */
	public String getImServer(){
		return imServer;
	}

	/**
	 * \~chinese
	 * 设置im 服务器端口号
	 * @param imPort 端口号
	 *
	 * \~english
	 * Set the custom im server port
	 * @param imPort port
	 */
	public void setImPort(int imPort){
		this.imPort = imPort;
		if(config == null){
			return;
		}
		config.setChatPort(imPort);
	}

	/**
	 * \~chinese
	 * 获取设置的im 服务器端口号
	 * @return 端口号
	 *
	 * \~english
	 * Get the im server port
	 * @return port
	 */
	public int getImPort(){
		return imPort;
	}

	/**
	 * \~chinese
	 * 设置rest 服务器地址
	 * @param restServer
	 *
	 * \~english
	 * Set the custom rest server
	 * @param restServer
	 */
	public void setRestServer(String restServer){
		if(restServer == null)
			return;

		this.restServer = restServer;
		if(config == null){
			return;
		}
		config.setRestServer(restServer);
	}

	/**
	 * \~chinese
	 * 获取设置的rest 服务器地址
	 * @return rest服务器地址
	 *
	 * \~english
	 * Get the rest server
	 * @return Rest server url
	 */
	public String getRestServer(){
		return restServer;
	}


	/**
	 * \~chinese
	 * 获取设置的数据上报服务器地址
	 * @return 数据上报服务器地址，有可能为空
	 *
	 * \~english
	 * Get the report server
	 * @return Report server url, may be null
     */
	public String getReportServer(){
		return reportServer;
	}


	/**
	 * \~chinese
	 * 设置数据上报服务器地址
	 * @param reportServer 数据上报服务器地址
	 *
	 * \~english
	 * Set the custom report server
	 * @param reportServer Report server url
	 */
	public void setReportServer(String reportServer){
		if(reportServer == null)
			return;
		this.reportServer = reportServer;
	}

	/**
	 * \~chinese
	 * 设置自动登录
	 * @param autoLogin
	 * 
	 * \~english
	 * Set login automatically
	 * @param autoLogin
	 */
	public void setAutoLogin(boolean autoLogin){
		enableAutoLogin = autoLogin;
	}
	
	/**
	 * \~chinese
	 * 获取是否自动登录
	 * @return 返回true表示已设置为自动登录
	 * 
	 * \~english
	 * Get whether to login automatically
	 * @return Return true means to set to login automatically
	 */
	public boolean getAutoLogin(){
		return enableAutoLogin;
	}

	/**
	 * \~chinese
	 * 获取FCM（GCM升级版->FCM）推送id
	 *
	 * @deprecated 使用 {@link EMPushConfig#getFcmSenderId()} 代替
	 *
	 * \~english
	 * Get FCM sender id
	 *
	 * @deprecated Use {@link EMPushConfig#getFcmSenderId()} instead
	 */
	@Deprecated
	public String getFCMNumber() {
		return fcmNumber;
	}

	/**
	 * \~chinese
	 * 设置FCM（GCM升级版->FCM）推送id
	 *
	 * @param number FCM 推送ID
	 *
	 * @deprecated 使用 {@link EMPushConfig.Builder#enableFCM(String)} 代替
	 *
	 * \~english
	 * Set FCM sender id
	 *
	 * @param number FCM sender id
	 *
	 * @deprecated Use {@link EMPushConfig.Builder#enableFCM(String)} instead
	 */
	@Deprecated
	public void setFCMNumber(String number) {
		fcmNumber = number;
	}

	/**
	 * \~chinese
	 * 获取是否使用谷歌FCM推送
	 *
	 * @deprecated FCM推送转移到应用层，不再需要此api
	 *
	 * \~english
	 * Whether to use Google FCM push
	 *
	 * @deprecated FCM push moves to the application layer, no longer requiring this API
	 */
	@Deprecated
	public boolean isUseFCM() {
		return useFCM;
	}

	/**
	 * \~chinese
	 * 设置是否开启谷歌FCM推送
	 *
	 * @param useFCM 谷歌FCM推送开关
	 *
	 * @deprecated FCM推送转移到应用层，不再需要此api
	 *
	 * \~english
	 * Enable or disable Google FCM push
	 * @param useFCM Google FCM push switch
	 *
	 * @deprecated FCM push moves to the application layer, no longer requiring this API
	 */
	@Deprecated
	public void setUseFCM(boolean useFCM) {
		this.useFCM = useFCM;
	}
	
	/**
	 * \~chinese
     * 设置用于小米推送的appid和appkey
     * @param mipushAppid 小米推送的appid
     * @param mipushAppkey 小米推送的appkey
	 *
	 * @deprecated 使用 {@link EMPushConfig.Builder#enableMiPush(String, String)} 代替
     * 
     * \~english
     * set the appid and appkey for Xiaomi Push
     * @param mipushAppid Xiaomi Push appid
     * @param mipushAppkey Xiaomi push appkey
	 *
	 * @deprecated Use {@link EMPushConfig.Builder#enableMiPush(String, String)} instead.
     */
	@Deprecated
    public void setMipushConfig(String mipushAppid, String mipushAppkey){
		mipushConfig = new EMChatConfigPrivate.EMMipushConfig(mipushAppid, mipushAppkey);
    }
    
    /**
	 * \~chinese
     * 获取用于小米推送的appid和appkey
     *
	 * @deprecated 使用 {@link EMPushConfig#getMiAppId()} 代替
	 *
     * \~english
     * Get the appid and appkey for Xiaomi Push
	 *
	 * @deprecated Use {@link EMPushConfig#getMiAppId()} and {@link EMPushConfig#getMiAppKey()} for instead.
     */
    @Deprecated
	public EMChatConfigPrivate.EMMipushConfig getMipushConfig() {
		return mipushConfig;
	}
    
	void setConfig(EMChatConfigPrivate config){
		this.config = config;
	}

	/**
	 * \~chinese
	 * 设置是否关闭DNS
	 * 默认为true，私有云部署需要关闭
	 *
	 * @param enable 是否关闭DNS
	 *
	 * \~english
	 * Enable/disable DNS
	 * Default is ture, private cloud deployment needs to be turned off
	 */
	public void enableDNSConfig(boolean enable) {
		enableDNSConfig = enable;
        if (config == null) {
            return;
        }
	    config.enableDnsConfig(enable);
	}

	/**
	 * \~chinese
	 * 获取是否关闭DNS，默认为true
	 *
	 * @return 返回是否关闭DNS
	 *
	 * \~english
	 * Get whether disable DNS, default is true
	 *
	 * @return Return whether to disable DNS
	 */
	public boolean getEnableDNSConfig() {
	    return enableDNSConfig;
	}

	/**
	 * \~chinese
	 * 允许使用https协议，默认值是true
	 * @param _useHttps 是否使用https协议
	 *
	 * @deprecated 使用 {@link #setUsingHttpsOnly(boolean)} 代替
	 *
	 * \~english
	 * Allow use https for rest operation, default is true
	 * @param _useHttps enable/disable https
	 *
	 * @deprecated Use {@link #setUsingHttpsOnly(boolean)} instead
	 */
    @Deprecated
	public void setUseHttps(boolean _useHttps) {
		useHttps = _useHttps;
		if (config == null) {
			return;
		}
		config.setUseHttps(_useHttps);
	}

	/**
	 * \~chinese
	 * 只使用https进行REST操作
	 * @param _usingHttpsOnly 是否只使用https
	 *
	 * \~english
	 * Only use https for rest operation
	 * @param _usingHttpsOnly If only use https
	 */
	public void setUsingHttpsOnly(boolean _usingHttpsOnly) {
        usingHttpsOnly = _usingHttpsOnly;
		if (config == null) {
			return;
		}
		config.setUsingHttpsOnly(_usingHttpsOnly);
	}

	/**
	 * \~chinese
	 * 获取是否只使用https进行REST操作，默认值是false
	 *
	 * @return 是否只使用https

	 * \~english
	 * Only use https for rest operation, default value is false
	 *
	 * @return If only use https
	 */
	public boolean getUsingHttpsOnly() {
		if (config != null) {
			return config.getUsingHttpsOnly();
		}
		return usingHttpsOnly;
	}
	/**
	 * \~chinese
	 * 是否自动将消息附件上传到Chat服务器
	 * 默认为true，使用Chat服务器上传下载
	 * @param transfer 是否上传到Chat服务器
	 *
	 * \~english
	 * Whether the message attachment is automatically uploaded to the chat server,
	 * default value is true, the default way to upload and download by chat server
	 *
	 * @param transfer Whether to upload to chat server
	 */
	public void setAutoTransferMessageAttachments(boolean transfer) {
		if (config == null) {
			serverTransfer = transfer;
			return;
		}
		config.setAutoTransferMessageAttachments(transfer);
	}
	/**
	 * \~chinese
	 * 获取是否使用Chat服务器进行上传下载，默认值是true
	 *
	 * @return 布尔值，是否上传到Chat服务器
	 *
	 * \~english
	 * Whether to Use chat sever to upload and download, default value is true
	 *
	 * @return Boolean, whether to upload to chat server
	 */
	public boolean getAutoTransferMessageAttachments() {
		if (config == null) {
			return serverTransfer;
		}
		return config.getAutoTransferMessageAttachments();
	}
	/**
	 * \~chinese
	 * 是否自动下载缩略图
	 * 默认是true，自动下载
	 * @param autodownload 布尔值，是否自动下载缩略图
	 *
	 * \~english
	 * Set Whether auto download thumbnail
	 * Default value is true, download automatically
	 *
	 * @param autodownload Boolean, whether to download thumbnail automatically
	 */
	public void setAutoDownloadThumbnail(boolean autodownload) {
		if (config == null) {
			isAutodownload = autodownload;
			return;
		}
		config.setAutodownloadThumbnail(autodownload);
	}
	/**
	 * \~chinese
	 * 获取是否自动下载缩略图，默认为true
	 * @return 是否自动下载缩略图
	 *
	 * \~english
	 * Get whether to download thumbnail automatically, default value is true
	 * @return Whether to download thumbnail automatically
	 */
	public boolean getAutodownloadThumbnail() {
		if (config == null) {
			return isAutodownload;
		}
		return config.getAutodownloadThumbnail();
	}


	private int fixedInterval = -1;

	/**
	 * \~chinese
	 * 设置固定的心跳间隔，不设置时会自动探测最佳心跳间隔
	 * @param interval 心跳时间间隔，单位为秒，建议范围为30s~300s之间
	 *
	 * \~english
	 * Set fixed heart beat interval, when not set, the optimal heartbeat interval is automatically detected
	 * @param interval interval of heart beat, in seconds (30~300)
	 */
	public void setFixedHBInterval(int interval) {
		if (interval < 10) this.fixedInterval = 10;
		if (interval > 300) this.fixedInterval = 300;
		this.fixedInterval = interval;
	}

	/**
	 * \~chinese
	 * 获取固定的心跳间隔
	 * @return 心跳时间间隔，单位为秒
	 *
	 * \~english
	 * Get fixed heart beat interval
	 * @return interval of heart beat, in seconds (30~300)
	 */
	public int getFixedInterval() {
		return this.fixedInterval;
	}


	/**
	 * \~chinese
	 * 获取SDK版本号
	 * @return SDK版本号
	 *
	 * \~english
	 * Get SDK version
	 * @return SDK version
	 */
	public String getVersion() {
		return config.getVersion();
	}

	/**
	 * \~chinese
	 * 获取本地保存的访问令牌
	 *
	 * @return 访问令牌
	 *
	 * \~english
	 * Get access token from local
	 *
	 * @return Access token
	 */
	public String getAccessToken() {
		return config.getAccessToken();
	}

	/**
	 * \~chinese
	 * 是否从服务器获取访问令牌
	 * @param b 是否从服务器获取
	 * @return 访问令牌
	 *
	 * \~english
	 * Whether to get access token from server
	 * @param b Whether to get from server
	 * @return Access token
	 */
	public String getAccessToken(boolean b) {
		return config.getAccessToken(b);
	}

	/**
	 * \~chinese
	 * 设置dns地址
	 * @param dnsUrl
	 *
	 * \~english
	 * Set dns url
	 * @param dnsUrl
	 */
	public void setDnsUrl(String dnsUrl) {
		this.dnsUrl = dnsUrl;
		if (config == null) {
			return;
		}
		config.setDnsUrl(dnsUrl);
	}

	/**
	 * \~chinese
	 * 获取dns地址
	 * @return  dns 地址
	 *
	 * \~english
	 * Get dns url
	 * @return  Dns url
	 */
	public String getDnsUrl() {
		if (config != null) {
			return config.getDnsUrl();
		}
		return dnsUrl;
	}

	/**
	 * \~chinese
	 * 获取用户设置的推送相关配置
	 *
	 * @return 推送配置
	 *
	 * \~english
	 * Get the push config set by user
	 */
	public EMPushConfig getPushConfig() {
		return pushConfig;
	}

	/**
	 * \~chinese
	 * 设置推送相关配置
	 *
	 * @param pushConfig 推送相关配置
	 *
	 * \~english
	 * Set push config
	 *
	 * @param pushConfig push config
	 */
	public void setPushConfig(EMPushConfig pushConfig) {
		this.pushConfig = pushConfig;
	}

	/**
	 * \~chinese
	 * 是否启动统计
	 *
	 * @return 布尔值
	 *
	 * \~english
	 * Whether to enable statistics
	 *
	 * @return Boolean
	 */
	public boolean isEnableStatistics() {
		return enableStatistics;
	}

	/**
	 * \~chinese
	 * 设置是否启用统计
	 *
	 * @param enableStatistics
	 *
	 * \~english
	 * Set whether to enable statistics
	 */
	public void setEnableStatistics(boolean enableStatistics) {
		this.enableStatistics = enableStatistics;
	}
}
