/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;

import java.io.File;

/**
 * \~chinese
 * 普通文件消息体
 * 
 * \~english
 * Normal file message body
 */
public class EMNormalFileMessageBody extends EMFileMessageBody implements Parcelable {

    /**
     * \~chinese
     * 构造一个普通文件消息体
     * @param file 文件
     *
     * \~english
     * Create a normal file message body
     * @param file
     */
	public EMNormalFileMessageBody(File file){
		this(Uri.fromFile(file));
	}
	

    /**
     * \~chinese
     * 构造一个普通文件消息体
     * @param localPath 文件的资源标识符（路径）
     *
     * \~english
     * Create a normal file message body
     * @param localPath The file Uri
     */
	public EMNormalFileMessageBody(Uri localPath){
		super(localPath);
		((EMAFileMessageBody) emaObject).setDisplayName(EMFileHelper.getInstance().getFilename(localPath));
	}

	EMNormalFileMessageBody(String fileName, String remoteUrl){
		super(fileName);
		super.setRemoteUrl(remoteUrl);
		EMLog.d("EMNormalFileMessageBody", "filename = "+fileName);
    }
	
	EMNormalFileMessageBody(EMAFileMessageBody body) {
		super(body);
	}
	
	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(((EMAFileMessageBody)emaObject).displayName());
		dest.writeString(((EMAFileMessageBody)emaObject).getLocalUrl());
		dest.writeString(((EMAFileMessageBody)emaObject).getRemoteUrl());
		dest.writeLong(((EMAFileMessageBody)emaObject).fileLength());
		dest.writeString(((EMAFileMessageBody)emaObject).getSecret());
	}

	public static final Parcelable.Creator<EMNormalFileMessageBody> CREATOR = new Parcelable.Creator<EMNormalFileMessageBody>() {
		public EMNormalFileMessageBody createFromParcel(Parcel in) {
			return new EMNormalFileMessageBody(in);
		}

		public EMNormalFileMessageBody[] newArray(int size) {
			return new EMNormalFileMessageBody[size];
		}
	};
	
	public EMNormalFileMessageBody() {
		super("");
	}
	
	private EMNormalFileMessageBody(Parcel in) {
		super("");
		// members from FileMessageBody
		((EMAFileMessageBody)emaObject).setDisplayName(in.readString());
		((EMAFileMessageBody)emaObject).setLocalPath(in.readString());
		((EMAFileMessageBody)emaObject).setRemotePath(in.readString());
		((EMAFileMessageBody)emaObject).setFileLength(in.readLong());
		((EMAFileMessageBody)emaObject).setSecretKey(in.readString());

	}
	
	public String toString() {
		return "normal file:" + ((EMAFileMessageBody)emaObject).displayName() + ",localUrl:" + ((EMAFileMessageBody)emaObject).getLocalUrl() 
				+ ",remoteUrl:" + ((EMAFileMessageBody)emaObject).getRemoteUrl()
				+ ",file size:" + ((EMAFileMessageBody)emaObject).fileLength();
	}

	/**
	 * \~chinese
	 * 获取文件大小
	 * @return 文件大小
	 * 
	 * \~english
	 * Get the normal file size
	 * @return File length
	 */
	public long getFileSize() {
		return ((EMAFileMessageBody)emaObject).fileLength();
	}
		
}
