package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAMucShareFile;

/**
 * \~chinese
 * 共享文件信息类
 * 例如：通过{@link EMGroupManager#fetchGroupSharedFileList(String, int, int)}接口获取群共享文件的相关信息：
 * <pre>
 *     List<EMMucSharedFile> sharedFiles = EMClient.getInstance().groupManager().fetchGroupSharedFileList(groupId, pageNum, pageSize);
 * </pre>
 *
 * \~english
 * Shared file info class
 * Such as, get information about group shared file through {@link EMGroupManager#fetchGroupSharedFileList(String, int, int)}:
 * <pre>
 *     List<EMMucSharedFile> sharedFiles = EMClient.getInstance().groupManager().fetchGroupSharedFileList(groupId, pageNum, pageSize);
 * </pre>
 */
public class EMMucSharedFile extends EMBase<EMAMucShareFile>{
    public EMMucSharedFile(){
        emaObject = new EMAMucShareFile();
    }

    public EMMucSharedFile(EMAMucShareFile shareFile){
        emaObject = new EMAMucShareFile(shareFile);
    }

    /**
     * \~chinese
     * 获取共享文件id
     * @return  共享文件id
     *
     * \~english
     * Get shared file id
     * @return  Shared file id
     */
    public String getFileId() {
        return emaObject.getFileId();
    }

    /**
     * \~chinese
     * 获取共享文件名称
     * @return  共享文件名称
     *
     * \~english
     * Get shared file name
     * @return  Shared file name
     */
    public String getFileName() {
        return emaObject.getFileName();
    }

    /**
     * \~chinese
     * 获取上传共享文件的成员id
     * @return  上传共享文件的成员id
     *
     * \~english
     * Get username who upload the shared file
     * @return  Username who upload the shared file
     */
    public String getFileOwner() {
        return emaObject.getFileOwner();
    }

    /**
     * \~chinese
     * 获取共享文件的更新时间，时间戳
     * @return 共享文件的更新时间，时间戳
     *
     * \~english
     * Get the update timestamp of shared file
     * @return  Update timestamp of shared file
     */
    public long getFileUpdateTime() {
        return emaObject.getUpdateTime();
    }

    /**
     * \~chinese
     * 获取共享文件的大小，单位为字节
     * @return 共享文件的大小，单位为字节
     *
     * \~english
     * Get the length of shared file, in bytes
     * @return  Length of shared file, in bytes
     */
    public long getFileSize() {
        return emaObject.getFileSize();
    }
}
