package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAGroupReadAck;

/**
 * \~chinese
 * 群消息已读回执情况
 * 通过{@link EMChatManager#fetchGroupReadAcks(String, int, String)}请求返回的结果，如下：
 * <pre>
 *     EMCursorResult<EMGroupReadAck> result = EMClient.getInstance().chatManager().fetchGroupReadAcks(msgId, pageSize, startAckId);
 * </pre>
 *
 * \~english
 * Group message read ack info class
 * By {@link EMChatManager#fetchGroupReadAcks(String, int, String)} to return requested result, such as:
 * <pre>
 *     EMCursorResult<EMGroupReadAck> result = EMClient.getInstance().chatManager().fetchGroupReadAcks(msgId, pageSize, startAckId);
 * </pre>
 */
public class EMGroupReadAck extends EMBase<EMAGroupReadAck> {

    EMAGroupReadAck emaObject;;

    public EMGroupReadAck(){
        this.emaObject = new EMAGroupReadAck();
    }

    public EMGroupReadAck(EMAGroupReadAck groupReadAck){
        this.emaObject = new EMAGroupReadAck(groupReadAck);
    }

    /**
     * \~chinese
     * 获取群消息已读回执id
     * @return  已读回执id
     *
     * \~english
     * Get read ack id of group message
     * @return  read ack id
     */
    public String getAckId() {
        return this.emaObject.getAckId();
    }

    /**
     * \~chinese
     * 返回群消息id
     * @return  群消息id
     *
     * \~english
     * Get group message id
     * @return  Group message id
     */
    public String getMsgId() {
        return this.emaObject.getMsgId();
    }

    /**
     * \~chinese
     * 获取发送已读回执的发送者id
     * @return 发送者id
     *
     * \~english
     * Get username who sends the read ack
     * @return Sender id
     */
    public String getFrom() {
        return this.emaObject.getFrom();
    }

    /**
     * \~chinese
     * 获取已读回执扩展内容
     * 发送已读回执{@link EMChatManager#ackGroupMessageRead(String, String, String)}，第三个参数传入的内容
     * @return 已读回执扩展内容
     *
     * \~english
     * Send group message read ack by {@link EMChatManager#ackGroupMessageRead(String, String, String)},
     * which is the third parameter passed
     * @return Extend content by read ack
     */
    public String getContent() {
        return this.emaObject.getContent();
    }

    /**
     * \~chinese
     * 获取发送已读回执的顺序
     * @return 发送已读回执的顺序
     *
     * \~english
     * Get the order in which group read ack is sent
     * @return Order in which group read ack is sent
     */
    public int getCount() {
        return this.emaObject.getCount();
    }

    /**
     * \~chinese
     * 获取发送已读回执的时间戳
     * @return 发送已读回执的时间戳
     *
     * \~english
     * Get the timestamp to send group message read ack
     * @return Timestamp to send group message read ack
     */
    public long getTimestamp() {
        return this.emaObject.getTimestamp();
    }

}
