package com.hyphenate.chat;

/**
 * \~chinese
 * 创建群组时的属性配置
 *
 * \~english
 * Create group related options
 */
public class EMGroupOptions {

    /**
     * \~chinese
     * 群最大成员数
     *
     * \~english
     * Maximum number of group members
     */
    public int maxUsers = 200;

    /**
     * \~chinese
     * 群类型，参考 {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}
     *
     * \~english
     * Group style, refer to {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}
     */
    public EMGroupManager.EMGroupStyle style = EMGroupManager.EMGroupStyle.EMGroupStylePrivateOnlyOwnerInvite;

    /**
     * \~chinese
     * 邀请进群是否需要对方同意
     *
     * 收到邀请是否自动入群有两个级别的设置，创建群组时inviteNeedConfirm设置及通过{@link EMOptions#setAutoAcceptGroupInvitation(boolean)}自动接受加群邀请，
     * 具体使用如下：
     * （1）如果设置inviteNeedConfirm为false，在服务端直接加被邀请人进群，
     * 被邀请人设置{@link EMOptions#setAutoAcceptGroupInvitation(boolean)}不起作用
     * (2) 如果设置inviteNeedConfirm为true，被邀请人设置{@link EMOptions#setAutoAcceptGroupInvitation(boolean)}才会起作用
     * {@link EMOptions#setAutoAcceptGroupInvitation(boolean)}为SDK级别操作，设置其为true时，SDK在被邀请人接收到入群邀请后，在SDK内部调用同意入群的api，
     * 自动接受邀请入群；
     * 当其被设置false，即非自动同意其邀请时，用户可以选择接受邀请进群，也可选择拒绝邀请
     *
     * \~english
     * This option define whether user will immediately joined the group when receive group invitation
     * Invitation will automatically into the group has two levels of set, inviteNeedConfirm set when creating group and by
     * {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} automatically accept group of invitation,
     * Specific use is as follows:
     * (1) If inviteNeedConfirm is set to false, add the invitee directly to the group on the server side,
     * and {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} set is invalid
     * (2) If inviteNeedConfirm is set to true, and {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} to be effective
     * {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} is SDK level operation, setting it to true,
     * after invitee receives group invitation, SDK automatically calls the API that accepts the invitation to join the group；
     * When it is set to false, which means that it does not automatically agree to its invitation,
     * user who received group invitation has option to decide whether join in
     */
    public boolean inviteNeedConfirm = false;

    /**
     * \~chinese
     * 群详情扩展，可以采用json格式，以包含更多群信息
     *
     * \~english
     * Group extension field, can be json format, which can contains more descriptions
     */
    public String extField;
}