/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import java.io.Serializable;

/**
 * \~chinese
 * 群组的基本信息, 用于获取公开群的列表
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 *
 * \~english
 * Get the basic group info. Used when get public group list
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 */
public class EMGroupInfo implements Serializable{

	private static final long serialVersionUID = -2004486389398310700L;
	private String groupId;
	private String groupName;
	
	/**
	 * \~chinese
	 * 构造函数
	 * @param groupId	群组id
	 * @param groupName	群组名称
	 *
	 * \~english
	 * construction of EMGroupInfo
	 * @param groupId	Group id
	 * @param groupName	Group name
	 */
	public EMGroupInfo(String groupId, String groupName) {
		this.groupId = groupId;
		this.groupName = groupName;
	}

	/**
	 * \~chinese
	 * 获取群组id
	 * @return 群组id
	 *
	 * \~english
	 * Get group id
	 * @return Group id
	 */
	public String getGroupId() {
		return groupId;
	}

	/**
	 * \~chinese
	 * 设置群组id
	 * @param groupId 群组id
	 *
	 * \~english
	 * Set group id
	 * @param groupId Group id
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	/**
	 * \~chinese
	 * 获取群组名称
	 * @return 群组名称 
	 *
	 * \~english
	 * Get group name
	 * @return Group name
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * \~chinese
	 * 设置群组名称
	 * @param groupName 群组名称
	 *
	 * \~english
	 * Set group name
	 * @param groupName Group name
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	
	@Override
	public String toString() {
		return groupName;
	}
}
