package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMADeviceInfo;

/**
 * \~chinese
 * 多设备登录信息类
 * 可以通过{@link EMClient#getLoggedInDevicesFromServer(String, String)}获取相关信息
 *
 * \~english
 * Multi-device information
 * Can use {@link EMClient#getLoggedInDevicesFromServer(String, String)} to get info
 */
public class EMDeviceInfo extends EMBase<EMADeviceInfo> {

    EMADeviceInfo emaObject;

    EMDeviceInfo(EMADeviceInfo emaDeviceInfo) {
        this.emaObject = emaDeviceInfo;
    }

    /**
     * \~chinese
     * 获取其他端设备信息
     * 可以通过设备信息区分设备类型，如：
     * <pre>
     *     String deviceResource = getResource();
     *     String deviceType = deviceResource.substring(0, deviceResource.indexOf("_"));
     *     if(deviceType.equalsIgnoreCase("ios")) {
     *         // iOS device
     *     }else if(deviceType.equalsIgnoreCase("android")) {
     *         // android device
     *     }else if(deviceType.equalsIgnoreCase("web")) {
     *         // web device
     *     }else if(deviceType.equalsIgnoreCase("win")) {
     *         // win device
     *     }else if(deviceType.equalsIgnoreCase("iMac")) {
     *         // mac device
     *     }
     * </pre>
     * @return 其他端设备信息
     *
     * \~english
     * Get other side device information
     * Through the device info, we can distinguish the device type, such as:
     * <pre>
     *     String deviceResource = getResource();
     *     String deviceType = deviceResource.substring(0, deviceResource.indexOf("_"));
     *     if(deviceType.equalsIgnoreCase("ios")) {
     *         // iOS device
     *     }else if(deviceType.equalsIgnoreCase("android")) {
     *         // android device
     *     }else if(deviceType.equalsIgnoreCase("web")) {
     *         // web device
     *     }else if(deviceType.equalsIgnoreCase("win")) {
     *         // win device
     *     }else if(deviceType.equalsIgnoreCase("iMac")) {
     *         // mac device
     *     }
     * </pre>
     * @return Other side device information
     */
    public String getResource() { return emaObject.getResource(); }

    /**
     * \~chinese
     * 返回设备的UUID（唯一标识码）
     * @return  设备的UUID（唯一标识码）
     *
     * \~english
     * Return the device's UUID
     * @return  Device's UUID
     */
    public String getDeviceUUID() { return emaObject.getDeviceUUID(); }

    /**
     * \~chinese
     * 返回设备型号名称
     * 例如："HUAWEICOL-AL10"
     * @return  设备型号名称
     *
     * \~english
     * Return the device type
     * Such as:"HUAWEICOL-AL10"
     * @return  Device type
     */
    public String getDeviceName() { return emaObject.getDeviceName(); }

    /*
    public void setResource(String resource)    { emaObject.setResource(resource); }
    public void setOsType(String osType)        { emaObject.setOsType(osType); }
    public void setOsVersion(String osVersion)  { emaObject.setOsVersion(osVersion); }
    public void setDeviceUUID(String deviceUUID) { emaObject.setDeviceUUID(deviceUUID); }
    public void setDeviceName(String deviceName) { emaObject.setDeviceName(deviceName); }
    */
}
