package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMACustomMessageBody;

import java.util.Map;

/**
 * \~chinese
 * 自定义消息体
 * <pre>
 *     EMCustomMessageBody body = new EMCustomMessageBody(event);
 * </pre>
 *
 * \~english
 * Custom message body
 * <pre>
 *     EMCustomMessageBody body = new EMCustomMessageBody(event);
 * </pre>
 */
public class EMCustomMessageBody extends EMMessageBody implements Parcelable {

    public EMCustomMessageBody(String event) {
        emaObject = new EMACustomMessageBody(event);
    }

    EMCustomMessageBody(EMACustomMessageBody body) {
        this.emaObject = body;
    }

    /**
     * \~chinese
     * 获取event
     *
     * @return event
     *
     * \~english
     * Get the event
     *
     * @return The event
     */
    public String event() { return ((EMACustomMessageBody)emaObject).event();}
    /**
     * \~chinese
     * 设置event
     *
     * \~english
     * Set the event
     */
    public void setEvent(String event) {
        ((EMACustomMessageBody)emaObject).setEvent(event);
    }

    /**
     * \~chinese
     * 获取自定义消息的键值对
     *
     * @return Map列表
     *
     * \~english
     * Get the params map
     *
     * @return Map
     */
    public Map<String, String> getParams() { return ((EMACustomMessageBody)emaObject).params(); }

    /**
     * \~chinese
     * 设置自定义消息的键值对
     *
     * \~english
     * Set the params map
     *
     */
    public void setParams(Map<String, String> params) {
        ((EMACustomMessageBody)emaObject).setParams(params);
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACustomMessageBody)emaObject).event());
    }

    public static final Parcelable.Creator<EMCustomMessageBody> CREATOR
            = new Parcelable.Creator<EMCustomMessageBody>() {
        public EMCustomMessageBody createFromParcel(Parcel in) {
            return new EMCustomMessageBody(in);
        }

        public EMCustomMessageBody[] newArray(int size) {
            return new EMCustomMessageBody[size];
        }
    };

    private EMCustomMessageBody(Parcel in) {
        emaObject = new EMACustomMessageBody(in.readString());
    }
}
