/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;


/**
 * \~chinese
 * EMContact 代表联系人 对象，这是个基类 。
 * 
 * \~english
 * EMContact used to be object of contact, and this is base class
 * 
 */
class EMContact implements Parcelable {
    
    /**
     * \~chinese
     * 此用户的唯一标示名, 即用户的环信id
     * 
     * \~english
     * the user name assigned from app, which should be unique in the application
     */
    protected String username;
    protected String nick;
    
	protected EMContact() {
    }
    
    /**
     * \~chinese
     * 由用户名构造EMContact对象
     * 
     * \~english
     * generate EMConcact object from app username
     * @param username
     */
    public EMContact(String username) {
    	this.username = username;
    }
    
    /**
     * \~chinese
     * 获取此联系人的用户名
     * @return
     * 
     * \~english
     * get username from contact
     */
    public String getUsername() {
        return username;
    }

    /**
     * \~chinese
     * 设置昵称
     * @param nick
     *
     * \~english
     * set nick name
     * @param nick
     */
    public void setNickname(String nick) {
        this.nick = nick;
    }

    /**
     * \~chinese
     * 获得此联系人的昵称
     *
     * @return
     * 
     * \~english
     * get nick name
     *
     * @return
     */
    public String getNickname()
    {
        if (nick == null) {
            return getUsername();
        } else {
            return nick;
        }
    }
    
    public String toString() {
        return "<contact " + ", username:" + username + ">";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(username);
    }
    
    public static final Parcelable.Creator<EMContact> CREATOR
            = new Parcelable.Creator<EMContact>() {
        public EMContact createFromParcel(Parcel in) {
            return new EMContact(in);
        }

        public EMContact[] newArray(int size) {
            return new EMContact[size];
        }
    };

    private EMContact(Parcel in) {
        username = in.readString();
    }
}
