/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMACmdMessageBody;

import java.util.Map;

/**
 * \~chinese
 * 命令消息体
 *
 * <pre>
 *     EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * </pre>
 *
 * \~english
 * Command message body
 *
 * <pre>
 *     EMCmdMessageBody body = new EMCmdMessageBody("delete", null);
 * </pre>
 *
 */
public class EMCmdMessageBody extends EMMessageBody implements Parcelable {
	
    /**
     * \~chinese
     * 创建一个命令消息
     *
     * @param action cmd指令
     * 
     * \~english
     * Construct command message
     *
     * @param action Command
     */
    public EMCmdMessageBody(String action) {
    	emaObject = new EMACmdMessageBody(action);
    }

    @Deprecated
    public EMCmdMessageBody(String action, Map<String, String> params){
        emaObject = new EMACmdMessageBody(action);
        ((EMACmdMessageBody)emaObject).setParams(params);
    }
    
    EMCmdMessageBody(EMACmdMessageBody body) {
    	this.emaObject = body;
    }
    
    /**
     * \~chinese
     * 获取命令
     *
     * @return 命令
     *
     * \~english
     * Get the action
     *
     * @return the action
     */
    public String action() {
    	return ((EMACmdMessageBody)emaObject).action();
    }

    /**
     * \~chinese
     * 获取消息体键值对
     * @return 键值对
     * @deprecated 使用 {@link EMMessage#ext()}代替
     *
     * \~english
     * Get the params map
     * @return Map
     * @deprecated Use {@link EMMessage#ext()} instead
     */
    @Deprecated
    public Map<String, String> getParams() { return ((EMACmdMessageBody)emaObject).params(); }

    /**
     * \~chinese
     * 判断当前CMD类型消息是否只投递在线用户
     * @return 布尔值，返回true表示只投递给在线用户
     *
     * \~english
     * Check whether this cmd msg is delivered to online users.
     * @return Boolean, return true means only deliver to online user
     */
    public boolean isDeliverOnlineOnly() {
        return ((EMACmdMessageBody)emaObject).isDeliverOnlineOnly();
    }

    /**
     * \~chinese
     * 设置当前CMD类型消息是否只投递在线用户，默认为false，即投递所有用户
     *
     * @param onlineOnly    是否只投递给在线用户
     *
     * \~english
     * Set whether current cmd msg only deliver to online users. False as default, means deliver to all users
     *
     * @param onlineOnly    Whether to deliver to online users only
     */
    public void deliverOnlineOnly(boolean onlineOnly) {
        ((EMACmdMessageBody)emaObject).deliverOnlineOnly(onlineOnly);
    }

    /**
     * \~chinese
     * 展示CMD消息的命令
     * @return  String
     *
     * \~english
     * Get the action of cmd message
     * @return  String
     */
    public String toString() {
        return "cmd:\"" + ((EMACmdMessageBody)emaObject).action() + "\"";
    }

	@Override
	public int describeContents() {
		return 0;
	}

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACmdMessageBody)emaObject).action());
    }
    
    public static final Parcelable.Creator<EMCmdMessageBody> CREATOR
            = new Parcelable.Creator<EMCmdMessageBody>() {
        public EMCmdMessageBody createFromParcel(Parcel in) {
            return new EMCmdMessageBody(in);
        }

        public EMCmdMessageBody[] newArray(int size) {
            return new EMCmdMessageBody[size];
        }
    };

    private EMCmdMessageBody(Parcel in) {
    	emaObject = new EMACmdMessageBody(in.readString());
    }
}
