/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;

import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;

/**
 * \~chinese
 * SDK保活的服务
 *
 * \~english
 * Sdk keep alive service
 */
@SuppressLint("Registered")
public class EMChatService extends Service {

	private final static String TAG = "chatservice";

	public class LocalBinder extends Binder {
		EMChatService getService() {
			return EMChatService.this;
		}
	}

	public void onCreate() {
		super.onCreate();
		EMLog.i(TAG, "chat service created");
	}


	public int onStartCommand(Intent _intent, int flags, int startId) {
		if(EMPushHelper.getInstance().getPushType() == EMPushType.FCM){
			EMLog.d(TAG, "start not sticky!");
			return Service.START_NOT_STICKY;
		} else {
			EMLog.d(TAG, "start sticky!");
			return Service.START_STICKY;
		}
	}

	@Override
	public void onDestroy() {
		EMLog.d(TAG, "onDestroy");

		if(EMPushHelper.getInstance().getPushType() == EMPushType.NORMAL
				&& EMClient.getInstance().isLoggedInBefore()){ // Keep this service alive.
			new Thread(new Runnable() {

				@Override
				public void run() {
					try {
						Intent intent = new Intent(EMChatService.this, EMChatService.class);
						startService(intent);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}).start();
		}
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		EMLog.d(TAG, "onBind");
		return mBinder;
	}

	@Override
	public boolean onUnbind(Intent intent) {
		return true;
	}

	// This is the object that receives interactions from clients. See
	// RemoteService for a more complete example.
	private final IBinder mBinder = new LocalBinder();

}
