package com.hyphenate;


import java.util.List;
/**
 * Created by linan on 17/4/17.
 */
/**
 * \~chinese
 * 多端多设备事件监听
 * 监听其他设备上当前用户的事件回调，包括联系人变化和群组变化
 * <pre>
 *     注册监听：
 *     EMClient.getInstance().addMultiDeviceListener(mMultiDeviceListener);
 *
 *     解注册监听：
 *     EMClient.getInstance().removeMultiDeviceListener(mMultiDeviceListener);
 * </pre>
 *
 * \~english
 * Multi-device listener
 * Listen current user action callback on other devices, including contact changes and group changes
 * <pre>
 *     Register listener:
 *     EMClient.getInstance().addMultiDeviceListener(mMultiDeviceListener);
 *
 *     Unregister listener:
 *     EMClient.getInstance().removeMultiDeviceListener(mMultiDeviceListener);
 * </pre>
 */
@SuppressWarnings("unused")
public interface EMMultiDeviceListener {

//    /**
//     * \~chinese
//     * 在其他设备上发起好友请求
//     *
//     * ~\english
//     * current user invited contact to be friend on other device
//     */
//    int CONTACT_ADD = 1;

    /**
     * \~chinese
     * 好友已经在其他设备上被移除
     *
     * \~english
     * Current user removed contact on other device
     */
    int CONTACT_REMOVE = 2;

    /**
     * \~chinese
     * 好友请求已经在其他设备上被同意
     *
     * \~english
     * Current user accepted contact invitation on other device
     */
    int CONTACT_ACCEPT          = 3;

    /**
     * \~chinese
     * 好友请求已经在其他设备上被拒绝
     *
     * \~english
     * Current user refused contact invitation on other device
     */
    int CONTACT_DECLINE         = 4;

    /**
     * \~chinese
     * 当前用户在其他设备加某人进入黑名单
     *
     * \~english
     * Current user added someone to blacklist on other device
     */
     int CONTACT_BAN           = 5;

    /**
     * \~chinese
     * 好友在其他设备被移出黑名单
     *
     * \~english
     * Current user removed someone from blacklist on other device
     */
     int CONTACT_ALLOW         = 6;



    /**
     * \~chinese
     * 当前用户在其他设备创建了群组
     *
     * \~english
     * Current user created group on other device
     */
    int GROUP_CREATE            = 10;

    /**
     * \~chinese
     * 当前用户在其他设备销毁了群组
     *
     * \~english
     * Current user destroyed group on other device
     */
    int GROUP_DESTROY           = 11;

    /**
     * \~chinese
     * 当前用户在其他设备已经加入群组
     *
     * \~english
     * Current user joined group on other device
     */
    int GROUP_JOIN              = 12;

    /**
     * \~chinese
     * 当前用户在其他设备已经离开群组
     *
     * \~english
     * Current user left the group on other device
     */
    int GROUP_LEAVE             = 13;

    /**
     * \~chinese
     * 当前用户在其他设备发起了群组申请
     *
     * \~english
     * Current user applied to join the group on other device
     */
    int GROUP_APPLY             = 14;

    /**
     * \~chinese
     * 当前用户在其他设备同意了群组申请
     *
     * \~english
     * Current user accepted group application on other device
     */
    int GROUP_APPLY_ACCEPT      = 15;

    /**
     * \~chinese
     * 当前用户在其他设备拒绝了群组申请
     *
     * \~english
     * Current user refused group application on other device
     */
    int GROUP_APPLY_DECLINE     = 16;

    /**
     * \~chinese
     * 当前用户在其他设备邀请了群成员
     *
     * \~english
     * Current user invited some one to join the group on other device
     */
    int GROUP_INVITE            = 17; //

    /**
     * \~chinese
     * 当前用户在其他设备同意了群组邀请
     *
     * \~english
     * Current user accepted the group invitation on other device
     */
    int GROUP_INVITE_ACCEPT     = 18; //

    /**
     * \~chinese
     * 当前用户在其他设备拒绝了群组邀请
     *
     * \~english
     * Current user declined the group invitation on other device
     */
    int GROUP_INVITE_DECLINE    = 19;

    /**
     * \~chinese
     * 当前用户在其他设备将某人踢出群
     *
     * \~english
     * Current user kicked someone from group on other device
     */
    int GROUP_KICK              = 20;

    /**
     * \~chinese
     * 当前用户在其他设备将成员加入群组黑名单
     *
     * \~english
     * Current user added someone into group blacklist on other device
     */
    int GROUP_BAN               = 21; //加入群组黑名单

    /**
     * \~chinese
     * 当前用户在其他设备将成员移除群组黑名单
     *
     * \~english
     * Current user removed someone from blacklist on other device
     */
    int GROUP_ALLOW             = 22;

    /**
     * \~chinese
     * 当前用户在其他设备屏蔽群组
     *
     * \~english
     * Current user blocked the group message on other device
     */
    int GROUP_BLOCK             = 23;

    /**
     * \~chinese
     * 当前用户在其他设备取消群组屏蔽
     *
     * \~english
     * Current user unblock the group message on other device
     */
    int GROUP_UNBLOCK           = 24;

    /**
     * \~chinese
     * 当前用户在其他设备转移群主
     *
     * \~english
     * Current user assigned group owner to someone on other device
     */
    int GROUP_ASSIGN_OWNER      = 25;

    /**
     * \~chinese
     * 当前用户在其他设备添加管理员
     *
     * \~english
     * Current user added administrator on other device
     */
    int GROUP_ADD_ADMIN         = 26;

    /**
     * \~chinese
     * 当前用户在其他设备移除管理员
     *
     * \~english
     * Current user removed administrator on other device
     */
    int GROUP_REMOVE_ADMIN      = 27;

    /**
     * \~chinese
     * 当前用户在其他设备禁言用户
     *
     * \~english
     * Current user added someone into mute list on other device
     */
    int GROUP_ADD_MUTE          = 28;

    /**
     * \~chinese
     * 当前用户在其他设备移除禁言
     *
     * \~english
     * Current user removed someone from mute list
     */
    int GROUP_REMOVE_MUTE       = 29;

    /**
     * \~chinese
     * 多端多设备联系人事件
     * @param event     事件，详见上方的常量
     * @param target    联系人id
     * @param ext       扩展信息
     *
     * \~english
     * Multi device onContact event
     * @param event     Event, see the constants above
     * @param target    Contact id
     * @param ext       Extended information
     */
    void onContactEvent(int event, String target, String ext);

    /**
     * \~chinese
     * 多端多设备群组事件
     * @param event         事件，详见上方常量
     * @param target        群组id
     * @param usernames     操作目标id集合
     *
     * \~english
     * Multi device onGroup event
     * @param event         Event, see the constants above
     * @param target        Group id
     * @param usernames     Operation target ids list
     */
    void onGroupEvent(int event, String target, List<String> usernames);
}
