/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * SDK中的错误常量类
 * 定义了SDK中常用的错误码
 *
 * \~english
 * Error constant class in SDK
 * Defines error codes commonly used in SDK
 */
public class EMError {
    
    /**
     * \~chinese
     * 无错误
     * 
     * \~english
     * No error
     */
    public final static int EM_NO_ERROR = 0;

    /**
     * \~chinese
     * 一般错误，未细分的错误一般通过此错误码抛出来
     * 
     * \~english
     * General error, not defined errors are generally thrown with this error code
     */
    public final static int GENERAL_ERROR = 1;
    
    /**
     * \~chinese
     * 网络异常
     * 
     * \~english
     * Network not available
     */
    public final static int NETWORK_ERROR = 2;

    /**
     * \~chinese
     * 服务受限
     *
     * \~english
     * Exceed to service limit
     */
    public final static int EXCEED_SERVICE_LIMIT = 4;

    /**
     * \~chinese
     * 余额不足
     *
     * \~english
     * Need charge for service
     */
    public final static int SERVICE_ARREARAGES = 5;


    /**
     * \~chinese
     * appkey不正确
     * 
     * \~english
     * App key is invalid
     */
    public final static int INVALID_APP_KEY = 100;

    /**
     * \~chinese
     * 用户id不正确
     * 
     * \~english
     * Username is invalid
     */
    public final static int INVALID_USER_NAME = 101;

    /**
     * \~chinese
     * 密码不正确
     * 
     * \~english
     * Password is invalid
     */
    public final static int INVALID_PASSWORD = 102;
    
    /**
     * \~chinese
     * url不正确
     * 
     * \~english
     * Url is invalid
     */
    public final static int INVALID_URL = 103;

    /**
     * \~chinese
     * token无效
     *
     * \~english
     * Invalid token
     */
    public final static int INVALID_TOKEN = 104;

    /**
     * \~chinese
     * 用户名过长
     *
     * \~english
     * Username too long
     */
    public final static int USER_NAME_TOO_LONG = 105;

    /**
     * \~chinese
     * 用户已登录
     * 
     * \~english
     * User already logged in
     */
    public final static int USER_ALREADY_LOGIN = 200;

    /**
     * \~chinese
     * 用户未登录
     * 
     * \~english
     * User has not login
     */
    public final static int USER_NOT_LOGIN = 201;

    /**
     * \~chinese
     * 用户id或密码错误
     * 
     * \~english
     * Username or password is wrong
     */
    public final static int USER_AUTHENTICATION_FAILED = 202;

    /**
     * \~chinese
     * 用户已经存在
     * 
     * \~english
     * User already exist
     */
    public final static int USER_ALREADY_EXIST = 203;

    /**
     * \~chinese
     * 不存在此用户
     * 
     * \~english
     * user does not exist
     */
    public final static int USER_NOT_FOUND = 204;

    /**
     * \~chinese
     * 参数不合法
     * 
     * \~english
     * Illegal argument
     */
    public final static int USER_ILLEGAL_ARGUMENT = 205;
    
    /**
     * \~chinese
     * 账户在另外一台设备登录
     * 
     * \~english
     * User already logged in on another device
     */
    public final static int USER_LOGIN_ANOTHER_DEVICE = 206;

    /**
     * \~chinese
     * 账户被删除
     * 
     * \~english
     * User has been removed from server
     */
    public final static int USER_REMOVED = 207;

    /**
     * \~chinese
     * 注册失败
     * 
     * \~english
     * Registration failed
     */
    public final static int USER_REG_FAILED = 208;

    /**
     * \~chinese
     * 更新用户信息失败
     * 
     * \~english
     * Update user info failed
     */
    public final static int USER_UPDATEINFO_FAILED = 209;

    /**
     * \~chinese
     * 用户没有该操作权限
     * 
     * \~english
     * User has no permission for the operation
     */
    public final static int USER_PERMISSION_DENIED = 210;
    
    /**
     * \~chinese
     * 绑定设备token失败
     * 
     * \~english
     * Device token binding failed
     */
    public final static int USER_BINDDEVICETOKEN_FAILED = 211;
    
    /**
     * \~chinese
     * 解绑设备token失败
     * 
     * \~english
     * Device token unbinding failed
     */
    public final static int USER_UNBIND_DEVICETOKEN_FAILED = 212;

    /**
     * \~chinese
     * 当前帐户已经绑定另外的设备，不允许当前设备自动登录
     *
     * \~english
     * Bind another device and do not allow auto login
     */
    public final static int USER_BIND_ANOTHER_DEVICE = 213;

    /**
     * \~chinese
     * 当前用户登陆的设备数过多
     *
     * \~english
     * User login on too many devices
     */
    public final static int USER_LOGIN_TOO_MANY_DEVICES = 214;

    /**
     * \~chinese
     * 用户在群组或聊天室被禁言
     *
     * \~english
     * User are muted in groups or chatrooms
     */
    public final static int USER_MUTED = 215;

    /**
     * \~chinese
     * 用户修改密码
     *
     * \~english
     * User has changed the password
     */
    public final static int USER_KICKED_BY_CHANGE_PASSWORD = 216;

    /**
     * \~chinese
     * 用户被其他设备踢掉
     *
     * \~english
     * User was kicked by other device or console backend
     */
    public final static int USER_KICKED_BY_OTHER_DEVICE = 217;
    /**
     * \~chinese
     * 其他用户已登录
     *
     * \~english
     * Another User is already login
     */
    public final static int USER_ALREADY_LOGIN_ANOTHER = 218;
    /**
     * \~chinese
     * 用户被管理员禁言
     *
     * \~english
     * english User is muted by admin
     */
    public final static int USER_MUTED_BY_ADMIN = 219;

    /**
     * \~chinese
     * 无法访问到服务器
     * 
     * \~english
     * Server is not reachable
     */
    public final static int SERVER_NOT_REACHABLE = 300;
    
    /**
     * \~chinese
     * 等待服务器响应超时
     * 
     * \~english
     * Waiting for server response timeout
     */
    public final static int SERVER_TIMEOUT = 301;

    /**
     * \~chinese
     * 服务器繁忙
     * 
     * \~english
     * Server is busy
     */
    public final static int SERVER_BUSY = 302;
    
    /**
     * \~chinese
     * 未知的server异常
     * 
     * \~english
     * Unknown server error
     */
    public final static int SERVER_UNKNOWN_ERROR = 303;

    /**
     * \~chinese
     * 获取dns失败
     * 
     * \~english
     * Get DNS list failed
     */
    public final static int SERVER_GET_DNSLIST_FAILED = 304;

    /**
     * \~chinese
     * chat功能限制
     * 
     * \~english
     * Service is restricted
     */
    public final static int SERVER_SERVICE_RESTRICTED = 305;


    /**
     * \~chinese
     * 文件不存在
     * 
     * \~english
     * File does not exist
     */
    public final static int FILE_NOT_FOUND = 400;
    
    /**
     * \~chinese
     * 文件不合法
     * 
     * \~english
     * Invalid file
     */
    public final static int FILE_INVALID = 401;
    
    /**
     * \~chinese
     * 文件上传失败
     * 
     * \~english
     * File uploading failed
     */
    public final static int FILE_UPLOAD_FAILED = 402;
    
    /**
     * \~chinese
     * 文件下载失败
     * 
     * \~english
     * File downloading failed
     */
    public final static int FILE_DOWNLOAD_FAILED = 403;

    /**
     * \~chinese
     * 文件删除失败
     *
     * \~english
     * File delete failed
     */
    public final static int FILE_DELETE_FAILED = 404;

    /**
     * \~chinese
     * 文件太大
     *
     * \~english
     * File too large
     */
    public final static int FILE_TOO_LARGE = 405;

    /**
     * \~chinese
     * 文件内容不合规
     *
     * \~english
     * File content improper
     */
    public final static int FILE_CONTENT_IMPROPER = 406;

    /**
     * \~chinese
     * 消息不合法
     * 
     * \~english
     * Invalid message
     */
    public final static int MESSAGE_INVALID = 500;
 
    /**
     * \~chinese
     * 消息内容包含非法或敏感词
     * 
     * \~english
     * Message include illegal content
     */
    public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;

    /**
     * \~chinese
     * 消息发送过快，触发限流
     * 
     * \~english
     * Message is sent too rapidly, triggering rate limit
     */
    public final static int MESSAGE_SEND_TRAFFIC_LIMIT = 502;

    /**
     * \~chinese
     * 消息加解密错误
     * 
     * \~english
     * Message encryption error
     */
    public final static int MESSAGE_ENCRYPTION_ERROR = 503;

    /**
     * \~chinese
     * 消息撤回超时
     *
     * \~english
     * Message recall timeout
     */
    public final static int MESSAGE_RECALL_TIME_LIMIT = 504;

    /**
     * \~chinese
     * 服务未开通
     *
     * \~english
     * Service not enabled
     */
    public final static int SERVICE_NOT_ENABLED = 505;

    /**
     * \~chinese
     * 消息已经过期
     *
     * \~english
     * Message has expired
     */
    public final static int MESSAGE_EXPIRED = 506;

    /**
     * \~chinese
     * 群组或者聊天室开启了禁言，用户不在白名单中
     *
     * \~english
     * All member muted, user is not in white list
     */
    public final static int MESSAGE_ILLEGAL_WHITELIST = 507;

    /**
     * \~chinese
     * 消息执行发送前回调，被用户自己的逻辑拦截
     *
     * \~english
     * Message was blocked by pre-delivery webhook
     */
    public final static int MESSAGE_EXTERNAL_LOGIC_BLOCKED = 508;

    /**
     * \~chinese
     * 群id不正确
     * 
     * \~english
     * Invalid group id
     */
    public final static int GROUP_INVALID_ID = 600;     
    /**
     * \~chinese
     * 已经加入的群组
     * 
     * \~english
     * Already joined group
     */
    public final static int GROUP_ALREADY_JOINED = 601;
    /**
     * \~chinese
     * 尚未加入此群组
     * 
     * \~english
     * User has not joined the group
     */
    public final static int GROUP_NOT_JOINED = 602;
    /**
     * \~chinese
     * 群组权限不够
     * 
     * \~english
     * User has no permission for the operation
     */
    public final static int GROUP_PERMISSION_DENIED = 603;      
    /**
     * \~chinese
     * 群成员已满
     * 
     * \~english
     * Group capacity reached
     */
    public final static int GROUP_MEMBERS_FULL = 604;
    
    /**
     * \~chinese
     * 群组不存在
     * 
     * \~english
     * Group does not exist
     */
    public final static int GROUP_NOT_EXIST = 605;


    /**
     * \~chinese
     * 聊天室id不正确
     * 
     * \~english
     * Invalid chatroom id
     */
    public final static int CHATROOM_INVALID_ID = 700;

    /**
     * \~chinese
     * 已经在此聊天室里
     * 
     * \~english
     * User already has joined the chatroom
     */
    public final static int CHATROOM_ALREADY_JOINED = 701;

    /**
     * \~chinese
     * 尚未加入此聊天室
     * \~english
     * User has not joined the chatroom
     */
    public final static int CHATROOM_NOT_JOINED = 702;

    /**
     * \~chinese
     * 聊天室权限不够
     * \~english
     * User has no permission for the operation
     */
    public final static int CHATROOM_PERMISSION_DENIED = 703;

    /**
     * \~chinese
     * 聊天室成员已满
     * 
     * \~english
     * Chatroom capacity reached
     */
    public final static int CHATROOM_MEMBERS_FULL = 704;
    
    /**
     * \~chinese
     * 聊天室不存在
     * 
     * \~english
     * Chatroom does not exist
     */
    public final static int CHATROOM_NOT_EXIST = 705;

    /**
     * \~chinese
     * 当前设备不支持推送
     *
     * \~english
     * Current device don't support push
     */
    public final static int PUSH_NOT_SUPPORT = 900;

    /**
     * \~chinese
     * 推送令牌绑定失败
     *
     * \~english
     * Push token bind failed
     */
    public final static int PUSH_BIND_FAILED = 901;

    /**
     * \~chinese
     * 推送令牌解除绑定失败
     *
     * \~english
     * Push token unbind failed
     */
    public final static int PUSH_UNBIND_FAILED = 902;

}
