/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * 聊天会话变更及收到会话已读的监听器
 *
 * \~english
 * The listener when conversation changed or received the conversation ack
 */
public interface EMConversationListener {

	/**
     * \~chinese
	 * 会话变更回调
     *
     * \~english
	 * Call back when conversation updated
	 */
    void onCoversationUpdate();

	/**
	 * \~chinese
	 * 收到会话已读回调
	 *
	 * 回调此方法的场景：
	 * （1）消息被接收方阅读（发送了会话已读回执）。
	 * SDK在接收到此事件时，会将本地数据库中该会话中消息的isAcked属性置为True。
	 * （2）多端多设备登录场景下，一端发送会话已读回执（conversation ack）,服务器端会将会话的未读消息数置为0，
	 * 同时其他端会回调此方法，并将本地数据库中该会话中消息的isRead属性置为True。
	 * @param from 发送channel ack方
	 * @param to   接收channel ack方
	 *
	 * \~english
	 * Call back when received conversation read ack
	 *
	 * Scenarios to call back this method:
	 * (1) Message read by receiver (conversation ack sent).
	 * Upon receiving this event, the SDK sets the isAcked property of the message in the conversation to True in the local database.
	 * (2) In the multi-device login scenario, one end sends a Conversation ACK,
	 * the server sets the number of unread messages to 0, and the other end calls back this method
	 * and sets the isRead property of the message in the conversation to True in the local database.
	 * @param from Username who send channel ack
	 * @param to   Username who receive channel ack
	 */
	void onConversationRead(String from, String to);
}
