/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 *  \~chinese
 *  联系人监听器
 *  监听联系变化，包括添加好友的申请，对方删除好友的通知, 对方同意好友请求，对方拒绝好友请求
 *  <pre>
 *      注册联系人监听：
 *      EMClient.getInstance().contactManager().setContactListener(mContactListener);
 *
 *      解注册联系人监听：
 *      EMClient.getInstance().contactManager().removeContactListener(mContactListener);
 *  </pre>
 *
 *  \~english
 *  Contact updates listener
 *  Listen for contact changes, including requests to add friends, notifications to delete friends,
 *  requests to accept friends, and requests to reject friends
 *  <pre>
 *     Register listener：
 *     EMClient.getInstance().contactManager().setContactListener(mContactListener);
 *
 *     Unregister listener：
 *     EMClient.getInstance().contactManager().removeContactListener(mContactListener);
 * </pre>
 */
public interface EMContactListener {
    
    /**
     * \~chinese
     * 增加联系人时回调此方法
     * @param username 增加的联系人
     * 
     * \~english
     * Call back when user is added as a contact by another user
     * @param username   New contact added
     */
    void onContactAdded(String username);
    
    /**
     * \~chinese
     * 被删除联系人时回调此方法
     * @param username 删除的联系人

     *
     * \~english
     * Call back when user is removed as a contact by another user
     * @param username    Contact removed
     */
    void onContactDeleted(String username);

    /**
     * \~chinese
     * 收到好友邀请
     * @param username 发起加为好友用户的名称
     * @param reason   对方发起好友邀请时发出的文字性描述
     *
     * \~english
     * Call back when user receives a friend request
     * @param username    User who initiated the friend request
     * @param reason      User's friend request message
     */
    void onContactInvited(String username, String reason);
    
    /**
     * \~chinese
     * 好友请求被同意
     * @param username
     *
     * \~english
     * Call back when a friend request is approved
     * @param username
     */
    void onFriendRequestAccepted(String username);

    /**
     * \~chinese
     * 好友请求被拒绝
     * @param username
     *
     * \~english
     * Call back when a friend request is declined
     * @param username
     */
    void onFriendRequestDeclined(String username);
}
