/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * 即时通讯状态连接监听器
 * 如果遇到弱网掉线情况，应用收到onDisconnected，此时不需要处理重连操作，SDK在底层自动处理重连
 * 回调函数只有onConnected, onDisconnected, 无需考虑连接中，断开中一类的中间状态
 * 
 * 注意：应用不要在这两个回调函数中更新界面，这两个现成属于工作线程，直接更新界面会导致界面的并发错误。也不要在这两个回调函数中
 * 做大量的耗时操作，这可能会影响其他监听器处理连接事件
 *
 * <pre>
 *     注册：
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *
 *     解注册：
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 * </pre>
 * 
 * \~english
 * Chat connection listener
 * For the occasion of onDisconnected during unstable signal condition, you don't need to reconnection manually,
 * chat SDK will handle it automatically
 * There are two states: connected and disconnected
 * 
 * Note: Do not update UI based on those methods, because this is called on worker thread.
 * Also do not put heavy computation work here, which might block other listeners to handle this connection event.</span>
 *
 * <pre>
 *     Register:
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *
 *     Unregister:
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 * </pre>
 *
 */
public interface EMConnectionListener {
    /**
     * \~chinese
     * 成功连接到chat服务器时触发
     *
     * \~english
     * Call back when connected to chat server successfully
     */
    void onConnected();

    /**
     * \~chinese
     * 和chat服务器断开连接时触发
     * 常见错误码有：{@link EMError#USER_REMOVED}，{@link EMError#USER_LOGIN_ANOTHER_DEVICE}，
     * {@link EMError#SERVER_SERVICE_RESTRICTED}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}及
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * \~english
     * Call back when disconnected from chat server
     * Common error code: {@link EMError#USER_REMOVED},{@link EMError#USER_LOGIN_ANOTHER_DEVICE},
     * {@link EMError#SERVER_SERVICE_RESTRICTED},{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD} and
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     */
    void onDisconnected(final int errorCode);
}
