/************************************************************		
*  * EaseMob CONFIDENTIAL 		
* __________________ 		
* Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 		
*  		
* NOTICE: All information contained herein is, and remains 		
* the property of EaseMob Technologies.		
* Dissemination of this information or reproduction of this material 		
* is strictly forbidden unless prior written permission is obtained		
* from EaseMob Technologies.		
*/
package com.hyphenate;

/**
 *  \~chinese
 *  通用的回调函数接口
 *  带参数返回值的回调函数见{@link EMValueCallBack}
 *
 *  \~english
 *  The general callback interface
 *  Callback with return value, see {@link EMValueCallBack}
 */
public interface EMCallBack {
    
    /**
     *  \~chinese
     *  成功时执行回调函数
     *
     *  \~english
     *  Callback function is executed on success
     */
    void onSuccess();

    /**
     *  \~chinese
     *  发生错误时调用的回调函数，详见{@link EMError}
     *
     *  @param code           错误代码
     *  @param error          包含文本类型的错误描述
     *
     *  \~english
     *  Callback function is called when an error occurs, see {@link EMError}
     *
     *  @param code           error code
     *  @param error          contain description of error
     */
    void onError(int code, String error);
    
    /**
     *  \~chinese
     *  刷新进度的回调函数
     *
     *  @param progress       进度信息
     *  @param status         包含文件描述的进度信息, 如果SDK没有提供，结果可能是"", 或者null
     *
     *  \~english
     *  Callback function is executed when progress update
     *
     *  @param progress       progress info
     *  @param status         Contain progress description. May be empty string "" or null
     *
     */
    void onProgress(int progress, String status);
}
