/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.net.Uri;
import android.view.ViewGroup;
import android.widget.TextView;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseEditTextUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;
import com.hyphenate.util.TextFormater;
import com.hyphenate.util.UriUtils;

public class EaseChatRowFile
extends EaseChatRow {
    private static final String TAG = EaseChatRowFile.class.getSimpleName();
    protected TextView fileNameView;
    protected TextView fileSizeView;
    protected TextView fileStateView;
    private EMNormalFileMessageBody fileMessageBody;

    public EaseChatRowFile(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowFile(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_file : R.layout.ease_row_sent_file, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.fileNameView = (TextView)this.findViewById(R.id.tv_file_name);
        this.fileSizeView = (TextView)this.findViewById(R.id.tv_file_size);
        this.fileStateView = (TextView)this.findViewById(R.id.tv_file_state);
        this.percentageView = (TextView)this.findViewById(R.id.percentage);
    }

    @Override
    protected void onSetUpView() {
        this.fileMessageBody = (EMNormalFileMessageBody)this.message.getBody();
        Uri filePath = this.fileMessageBody.getLocalUri();
        this.fileNameView.setText((CharSequence)this.fileMessageBody.getFileName());
        this.fileNameView.post(() -> {
            String content = EaseEditTextUtils.ellipsizeMiddleString(this.fileNameView, this.fileMessageBody.getFileName(), this.fileNameView.getMaxLines(), this.fileNameView.getWidth() - this.fileNameView.getPaddingLeft() - this.fileNameView.getPaddingRight());
            this.fileNameView.setText((CharSequence)content);
        });
        this.fileSizeView.setText((CharSequence)TextFormater.getDataSize((long)this.fileMessageBody.getFileSize()));
        if (this.message.direct() == EMMessage.Direct.SEND) {
            if (UriUtils.isFileExistByUri((Context)this.context, (Uri)filePath) && this.message.status() == EMMessage.Status.SUCCESS) {
                this.fileStateView.setText(R.string.have_uploaded);
            } else {
                this.fileStateView.setText((CharSequence)"");
            }
        }
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            if (UriUtils.isFileExistByUri((Context)this.context, (Uri)filePath)) {
                this.fileStateView.setText(R.string.have_downloaded);
            } else {
                this.fileStateView.setText(R.string.did_not_download);
            }
        }
    }

    @Override
    protected void onMessageCreate() {
        super.onMessageCreate();
        this.progressBar.setVisibility(0);
        if (this.percentageView != null) {
            this.percentageView.setVisibility(4);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(4);
        }
    }

    @Override
    protected void onMessageSuccess() {
        super.onMessageSuccess();
        this.progressBar.setVisibility(4);
        if (this.percentageView != null) {
            this.percentageView.setVisibility(4);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(4);
        }
        if (this.message.direct() == EMMessage.Direct.SEND && this.fileStateView != null) {
            this.fileStateView.setText(R.string.have_uploaded);
        }
    }

    @Override
    protected void onMessageError() {
        super.onMessageError();
        this.progressBar.setVisibility(4);
        if (this.percentageView != null) {
            this.percentageView.setVisibility(4);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(0);
        }
    }

    @Override
    protected void onMessageInProgress() {
        super.onMessageInProgress();
        if (this.progressBar.getVisibility() != 0) {
            this.progressBar.setVisibility(0);
        }
        if (this.percentageView != null) {
            this.percentageView.setVisibility(0);
            this.percentageView.setText((CharSequence)(this.message.progress() + "%"));
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(4);
        }
    }
}

