/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.hyphenate.chat.EMCustomMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;
import java.util.List;

public class EaseChatRowCustom
extends EaseChatRow {
    private TextView contentView;
    private EaseDingMessageHelper.IAckUserUpdateListener userUpdateListener = new EaseDingMessageHelper.IAckUserUpdateListener(){

        @Override
        public void onUpdate(List<String> list) {
            EaseChatRowCustom.this.onAckUserUpdate(list.size());
        }
    };

    public EaseChatRowCustom(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowCustom(Context context, EMMessage message, int position, BaseAdapter adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_message : R.layout.ease_row_sent_message, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.contentView = (TextView)this.findViewById(R.id.tv_chatcontent);
    }

    @Override
    public void onSetUpView() {
        EMCustomMessageBody txtBody = (EMCustomMessageBody)this.message.getBody();
        String msg = this.context.getString(R.string.custom_message, new Object[]{txtBody.event()});
        this.contentView.setText((CharSequence)msg);
    }

    public void onAckUserUpdate(final int count) {
        if (this.ackedView != null && this.isSender()) {
            this.ackedView.post(new Runnable(){

                @Override
                public void run() {
                    EaseChatRowCustom.this.ackedView.setVisibility(0);
                    EaseChatRowCustom.this.ackedView.setText((CharSequence)String.format(EaseChatRowCustom.this.getContext().getString(R.string.group_ack_read_count), count));
                }
            });
        }
    }

    @Override
    protected void onMessageCreate() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(8);
        }
    }

    @Override
    protected void onMessageSuccess() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(8);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(8);
        }
        if (this.isSender() && EaseDingMessageHelper.get().isDingMessage(this.message) && this.ackedView != null) {
            this.ackedView.setVisibility(0);
            int count = this.message.groupAckCount();
            this.ackedView.setText((CharSequence)String.format(this.getContext().getString(R.string.group_ack_read_count), count));
        }
        EaseDingMessageHelper.get().setUserUpdateListener(this.message, this.userUpdateListener);
    }

    @Override
    protected void onMessageError() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(8);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(0);
        }
    }

    @Override
    protected void onMessageInProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(8);
        }
    }
}

