/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.ui.EaseBaiduMapActivity;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowLocation;
import com.hyphenate.exceptions.HyphenateException;

public class EaseLocationViewHolder
extends EaseChatRowViewHolder {
    public EaseLocationViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView, itemClickListener);
    }

    public static EaseChatRowViewHolder create(ViewGroup parent, boolean isSender, MessageListItemClickListener itemClickListener) {
        return new EaseLocationViewHolder((View)new EaseChatRowLocation(parent.getContext(), isSender), itemClickListener);
    }

    @Override
    public void onBubbleClick(EMMessage message) {
        super.onBubbleClick(message);
        EMLocationMessageBody locBody = (EMLocationMessageBody)message.getBody();
        EaseBaiduMapActivity.actionStart(this.getContext(), locBody.getLatitude(), locBody.getLongitude(), locBody.getAddress());
    }

    @Override
    protected void handleReceiveMessage(EMMessage message) {
        super.handleReceiveMessage(message);
        if (!message.isAcked() && message.getChatType() == EMMessage.ChatType.Chat) {
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
    }
}

