/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.Context;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import com.hyphenate.easeui.widget.EaseImageView;

public class EaseUserUtils {
    public static EaseUser getUserInfo(String username) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        return provider == null ? null : provider.getUser(username);
    }

    public static void setUserAvatarStyle(EaseImageView imageView) {
        EaseAvatarOptions avatarOptions = EaseIM.getInstance().getAvatarOptions();
        if (avatarOptions == null || imageView == null) {
            return;
        }
        if (avatarOptions.getAvatarShape() != 0) {
            imageView.setShapeType(avatarOptions.getAvatarShape());
        }
        if (avatarOptions.getAvatarBorderWidth() != 0) {
            imageView.setBorderWidth(avatarOptions.getAvatarBorderWidth());
        }
        if (avatarOptions.getAvatarBorderColor() != 0) {
            imageView.setBorderColor(avatarOptions.getAvatarBorderColor());
        }
        if (avatarOptions.getAvatarRadius() != 0) {
            imageView.setRadius(avatarOptions.getAvatarRadius());
        }
    }

    public static void setUserAvatar(Context context, String username, ImageView imageView) {
        EaseUser user = EaseUserUtils.getUserInfo(username);
        if (user != null && user.getAvatar() != null) {
            try {
                int avatarResId = Integer.parseInt(user.getAvatar());
                Glide.with((Context)context).load(Integer.valueOf(avatarResId)).into(imageView);
            }
            catch (Exception e) {
                Glide.with((Context)context).load(user.getAvatar()).apply(RequestOptions.placeholderOf((int)R.drawable.ease_default_avatar).diskCacheStrategy(DiskCacheStrategy.ALL)).into(imageView);
            }
        } else {
            Glide.with((Context)context).load(Integer.valueOf(R.drawable.ease_default_avatar)).into(imageView);
        }
    }

    public static void setUserNick(String username, TextView textView) {
        if (textView != null) {
            EaseUser user = EaseUserUtils.getUserInfo(username);
            if (user != null && user.getNickname() != null) {
                textView.setText((CharSequence)user.getNickname());
            } else {
                textView.setText((CharSequence)username);
            }
        }
    }
}

