/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.contact;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.PopupMenu;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.interfaces.OnItemLongClickListener;
import com.hyphenate.easeui.modules.contact.adapter.EaseContactCustomAdapter;
import com.hyphenate.easeui.modules.contact.adapter.EaseContactListAdapter;
import com.hyphenate.easeui.modules.contact.interfaces.IContactCustomListLayout;
import com.hyphenate.easeui.modules.contact.interfaces.IContactListLayout;
import com.hyphenate.easeui.modules.contact.interfaces.IContactListStyle;
import com.hyphenate.easeui.modules.contact.interfaces.OnContactLoadListener;
import com.hyphenate.easeui.modules.contact.model.EaseContactSetStyle;
import com.hyphenate.easeui.modules.contact.presenter.EaseContactPresenter;
import com.hyphenate.easeui.modules.contact.presenter.EaseContactPresenterImpl;
import com.hyphenate.easeui.modules.contact.presenter.IEaseContactListView;
import com.hyphenate.easeui.modules.interfaces.IPopupMenu;
import com.hyphenate.easeui.modules.menu.EasePopupMenuHelper;
import com.hyphenate.easeui.modules.menu.OnPopupMenuDismissListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuItemClickListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuPreShowListener;
import com.hyphenate.easeui.widget.EaseImageView;
import com.hyphenate.easeui.widget.EaseRecyclerView;
import java.util.ArrayList;
import java.util.List;

public class EaseContactListLayout
extends EaseRecyclerView
implements IEaseContactListView,
IContactListLayout,
IContactCustomListLayout,
IContactListStyle,
IPopupMenu {
    private EaseContactSetStyle contactSetModel = new EaseContactSetStyle();
    private EaseContactPresenter presenter;
    private ConcatAdapter concatAdapter;
    private EaseContactListAdapter listAdapter;
    private OnItemClickListener itemListener;
    private OnItemLongClickListener itemLongListener;
    private OnPopupMenuItemClickListener popupMenuItemClickListener;
    private OnPopupMenuDismissListener dismissListener;
    private OnPopupMenuPreShowListener menuPreShowListener;
    private EasePopupMenuHelper menuHelper;
    private OnItemClickListener customItemClickListener;
    private OnContactLoadListener loadListener;
    private boolean showDefaultMenu = true;
    private float touchX;
    private float touchY;
    private EaseContactCustomAdapter customAdapter;

    public EaseContactListLayout(Context context) {
        this(context, null);
    }

    public EaseContactListLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseContactListLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.contactSetModel.setShowItemHeader(true);
        this.presenter = new EaseContactPresenterImpl();
        if (context instanceof AppCompatActivity) {
            ((AppCompatActivity)context).getLifecycle().addObserver((LifecycleObserver)this.presenter);
        }
        this.initAttrs(context, attrs);
        this.initViews();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EaseContactListLayout);
            float titleTextSize = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_title_text_size, EaseContactListLayout.sp2px(context, 16.0f));
            this.contactSetModel.setTitleTextSize(titleTextSize);
            int titleTextColorRes = a.getResourceId(R.styleable.EaseContactListLayout_ease_contact_item_title_text_color, -1);
            int titleTextColor = titleTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)titleTextColorRes) : a.getColor(R.styleable.EaseContactListLayout_ease_contact_item_title_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_contact_color_item_title));
            this.contactSetModel.setTitleTextColor(titleTextColor);
            float headerTextSize = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_header_text_size, EaseContactListLayout.sp2px(context, 16.0f));
            this.contactSetModel.setHeaderTextSize(headerTextSize);
            int headerTextColorRes = a.getResourceId(R.styleable.EaseContactListLayout_ease_contact_item_header_text_color, -1);
            int headerTextColor = headerTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)titleTextColorRes) : a.getColor(R.styleable.EaseContactListLayout_ease_contact_item_header_text_color, ContextCompat.getColor((Context)context, (int)R.color.ease_contact_color_item_header));
            this.contactSetModel.setHeaderTextColor(headerTextColor);
            this.contactSetModel.setHeaderBgDrawable(a.getDrawable(R.styleable.EaseContactListLayout_ease_contact_item_header_background));
            Drawable avatarDefaultDrawable = a.getDrawable(R.styleable.EaseContactListLayout_ease_contact_item_avatar_default_src);
            float avatarSize = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_avatar_size, 0.0f);
            int shapeType = a.getInteger(R.styleable.EaseContactListLayout_ease_contact_item_avatar_shape_type, -1);
            float avatarRadius = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_avatar_radius, EaseContactListLayout.dip2px(context, 50.0f));
            float borderWidth = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_avatar_border_width, 0.0f);
            int borderColorRes = a.getResourceId(R.styleable.EaseContactListLayout_ease_contact_item_avatar_border_color, -1);
            int borderColor = borderColorRes != -1 ? ContextCompat.getColor((Context)context, (int)borderColorRes) : a.getColor(R.styleable.EaseContactListLayout_ease_contact_item_avatar_border_color, 0);
            this.contactSetModel.setAvatarDefaultSrc(avatarDefaultDrawable);
            this.contactSetModel.setAvatarSize(avatarSize);
            this.contactSetModel.setShapeType(shapeType);
            this.contactSetModel.setAvatarRadius(avatarRadius);
            this.contactSetModel.setBorderWidth(borderWidth);
            this.contactSetModel.setBorderColor(borderColor);
            float itemHeight = a.getDimension(R.styleable.EaseContactListLayout_ease_contact_item_height, EaseContactListLayout.dip2px(context, 75.0f));
            Drawable bgDrawable = a.getDrawable(R.styleable.EaseContactListLayout_ease_contact_item_background);
            this.contactSetModel.setItemHeight(itemHeight);
            this.contactSetModel.setBgDrawable(bgDrawable);
            a.recycle();
        }
    }

    private void initViews() {
        this.presenter.attachView(this);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.concatAdapter = new ConcatAdapter(new RecyclerView.Adapter[0]);
        this.listAdapter = new EaseContactListAdapter();
        this.listAdapter.setSettingModel(this.contactSetModel);
        this.addHeader();
        this.concatAdapter.addAdapter((RecyclerView.Adapter)this.listAdapter);
        this.setAdapter((RecyclerView.Adapter)this.concatAdapter);
        this.menuHelper = new EasePopupMenuHelper();
        this.initListener();
    }

    private void addHeader() {
        this.customAdapter = new EaseContactCustomAdapter();
        this.customAdapter.setSettingModel(this.contactSetModel);
        this.concatAdapter.addAdapter((RecyclerView.Adapter)this.customAdapter);
    }

    private void initListener() {
        this.listAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (EaseContactListLayout.this.itemListener != null) {
                    EaseContactListLayout.this.itemListener.onItemClick(view, position);
                }
            }
        });
        this.listAdapter.setOnItemLongClickListener(new OnItemLongClickListener(){

            @Override
            public boolean onItemLongClick(View view, int position) {
                if (EaseContactListLayout.this.itemLongListener != null) {
                    return EaseContactListLayout.this.itemLongListener.onItemLongClick(view, position);
                }
                if (EaseContactListLayout.this.showDefaultMenu) {
                    EaseContactListLayout.this.showDefaultMenu(view, position, (EaseUser)EaseContactListLayout.this.listAdapter.getItem(position));
                    return true;
                }
                return false;
            }
        });
        this.customAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (EaseContactListLayout.this.customItemClickListener != null) {
                    EaseContactListLayout.this.customItemClickListener.onItemClick(view, position);
                }
            }
        });
    }

    private void showDefaultMenu(View view, final int position, final EaseUser user) {
        this.menuHelper.addItemMenu(0, R.id.action_add_note, 0, this.getContext().getString(R.string.ease_contact_menu_add_note));
        this.menuHelper.initMenu(view);
        this.menuHelper.findItemVisible(R.id.action_add_note, false);
        if (this.menuPreShowListener != null) {
            this.menuPreShowListener.onMenuPreShow(this.menuHelper, position);
        }
        this.menuHelper.setOnPopupMenuItemClickListener(new OnPopupMenuItemClickListener(){

            @Override
            public boolean onMenuItemClick(MenuItem item, int menuPos) {
                if (EaseContactListLayout.this.popupMenuItemClickListener != null) {
                    return EaseContactListLayout.this.popupMenuItemClickListener.onMenuItemClick(item, position);
                }
                if (item.getItemId() == R.id.action_add_note) {
                    EaseContactListLayout.this.presenter.addNote(position, user);
                    return true;
                }
                return false;
            }
        });
        this.menuHelper.setOnPopupMenuDismissListener(new OnPopupMenuDismissListener(){

            @Override
            public void onDismiss(PopupMenu menu) {
                if (EaseContactListLayout.this.dismissListener != null) {
                    EaseContactListLayout.this.dismissListener.onDismiss(menu);
                }
            }
        });
        this.menuHelper.show((int)this.getTouchX(), 0);
    }

    public void loadDefaultData() {
        this.presenter.loadData();
    }

    public void setData(List<EaseUser> data) {
        this.presenter.sortData(data);
    }

    public void setDataNotSort(List<EaseUser> data) {
        this.listAdapter.setData(data);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.touchX = ev.getX();
        this.touchY = ev.getY();
        return super.dispatchTouchEvent(ev);
    }

    public float getTouchX() {
        return this.touchX;
    }

    public float getTouchY() {
        return this.touchY;
    }

    public void notifyDataSetChanged() {
        this.listAdapter.setSettingModel(this.contactSetModel);
        this.listAdapter.notifyDataSetChanged();
    }

    @Override
    public void setPresenter(EaseContactPresenter presenter) {
        this.presenter = presenter;
        if (this.getContext() instanceof AppCompatActivity) {
            ((AppCompatActivity)this.getContext()).getLifecycle().addObserver((LifecycleObserver)presenter);
        }
        this.presenter.attachView(this);
    }

    @Override
    public void showItemDefaultMenu(boolean showDefault) {
        this.showDefaultMenu = showDefault;
    }

    @Override
    public void showItemHeader(boolean showItemHeader) {
        this.contactSetModel.setShowItemHeader(showItemHeader);
        this.notifyDataSetChanged();
    }

    @Override
    public EaseContactListAdapter getListAdapter() {
        return this.listAdapter;
    }

    @Override
    public EaseUser getItem(int position) {
        if (position >= this.listAdapter.getData().size()) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        return (EaseUser)this.listAdapter.getItem(position);
    }

    @Override
    public void setItemBackGround(Drawable backGround) {
        this.contactSetModel.setBgDrawable(backGround);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemHeight(int height) {
        this.contactSetModel.setItemHeight(height);
        this.notifyDataSetChanged();
    }

    @Override
    public void setHeaderBackGround(Drawable backGround) {
        this.contactSetModel.setHeaderBgDrawable(backGround);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTitleTextSize(int textSize) {
        this.contactSetModel.setTitleTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTitleTextColor(int textColor) {
        this.contactSetModel.setTitleTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setHeaderTextSize(int textSize) {
        this.contactSetModel.setHeaderTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setHeaderTextColor(int textColor) {
        this.contactSetModel.setHeaderTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarDefaultSrc(Drawable src) {
        this.contactSetModel.setAvatarDefaultSrc(src);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarSize(float avatarSize) {
        this.contactSetModel.setAvatarSize(avatarSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarShapeType(EaseImageView.ShapeType shapeType) {
        this.contactSetModel.setShapeType(shapeType);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarRadius(int radius) {
        this.contactSetModel.setAvatarRadius(radius);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarBorderWidth(int borderWidth) {
        this.contactSetModel.setBorderWidth(borderWidth);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarBorderColor(int borderColor) {
        this.contactSetModel.setBorderColor(borderColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void clearMenu() {
        this.menuHelper.clear();
    }

    @Override
    public void addItemMenu(int groupId, int itemId, int order, String title) {
        this.menuHelper.addItemMenu(groupId, itemId, order, title);
    }

    @Override
    public void findItemVisible(int id2, boolean visible) {
        this.menuHelper.findItemVisible(id2, visible);
    }

    @Override
    public void setOnPopupMenuPreShowListener(OnPopupMenuPreShowListener preShowListener) {
        this.menuPreShowListener = preShowListener;
    }

    @Override
    public void setOnPopupMenuItemClickListener(OnPopupMenuItemClickListener listener) {
        this.popupMenuItemClickListener = listener;
    }

    @Override
    public void setOnPopupMenuDismissListener(OnPopupMenuDismissListener listener) {
        this.dismissListener = listener;
    }

    @Override
    public EasePopupMenuHelper getMenuHelper() {
        return this.menuHelper;
    }

    @Override
    public void addHeaderAdapter(RecyclerView.Adapter adapter) {
        this.concatAdapter.addAdapter(0, adapter);
    }

    @Override
    public void addFooterAdapter(RecyclerView.Adapter adapter) {
        this.concatAdapter.addAdapter(adapter);
    }

    @Override
    public void removeAdapter(RecyclerView.Adapter adapter) {
        this.concatAdapter.removeAdapter(adapter);
    }

    @Override
    public void addRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.addItemDecoration(decor);
    }

    @Override
    public void removeRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.removeItemDecoration(decor);
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener listener) {
        this.itemListener = listener;
    }

    @Override
    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.itemLongListener = listener;
    }

    @Override
    public void loadContactListSuccess(List<EaseUser> data) {
        this.presenter.sortData(data);
    }

    @Override
    public void loadContactListNoData() {
        if (this.loadListener != null) {
            this.loadListener.loadDataFinish(new ArrayList<EaseUser>());
        }
    }

    @Override
    public void loadContactListFail(String message) {
        if (this.loadListener != null) {
            this.loadListener.loadDataFail(message);
        }
    }

    @Override
    public void sortContactListSuccess(List<EaseUser> data) {
        if (this.loadListener != null) {
            this.loadListener.loadDataFinish(data);
        }
        this.listAdapter.setData(data);
    }

    @Override
    public void refreshList() {
        this.notifyDataSetChanged();
    }

    @Override
    public void refreshList(int position) {
        this.listAdapter.notifyItemChanged(position);
    }

    @Override
    public void addNote(int position) {
        this.listAdapter.notifyItemChanged(position);
    }

    @Override
    public void addNoteFail(int position, String message) {
        Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)0).show();
    }

    public static float dip2px(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float sp2px(Context context, float value) {
        return TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public Context context() {
        return this.getContext();
    }

    @Override
    public void addCustomItem(int id2, int imageResource, String name) {
        if (this.customAdapter != null) {
            this.customAdapter.addItem(id2, imageResource, name);
        }
    }

    @Override
    public void addCustomItem(int id2, String image, String name) {
        if (this.customAdapter != null) {
            this.customAdapter.addItem(id2, image, name);
        }
    }

    @Override
    public void setOnCustomItemClickListener(OnItemClickListener listener) {
        this.customItemClickListener = listener;
    }

    @Override
    public void setOnContactLoadListener(OnContactLoadListener loadListener) {
        this.loadListener = loadListener;
    }

    @Override
    public EaseContactCustomAdapter getCustomAdapter() {
        return this.customAdapter;
    }
}

