/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.manager.EaseChatPresenter;
import com.hyphenate.easeui.model.EaseNotifier;
import com.hyphenate.easeui.provider.EaseConversationInfoProvider;
import com.hyphenate.easeui.provider.EaseEmojiconInfoProvider;
import com.hyphenate.easeui.provider.EaseSettingsProvider;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;

public class EaseIM {
    private static final String TAG = EaseIM.class.getSimpleName();
    private static EaseIM instance;
    private EaseSettingsProvider settingsProvider;
    private EaseEmojiconInfoProvider mEmojiconInfoProvider;
    private EaseUserProfileProvider userProvider;
    private EaseConversationInfoProvider conversationInfoProvider;
    private EaseAvatarOptions avatarOptions;
    private Context appContext = null;
    private EaseNotifier notifier = null;
    private boolean sdkInited = false;
    public boolean isVoiceCalling;
    public boolean isVideoCalling;
    private EaseChatPresenter presenter;

    private EaseIM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseIM getInstance() {
        if (instance != null) return instance;
        Class<EaseIM> clazz = EaseIM.class;
        synchronized (EaseIM.class) {
            if (instance != null) return instance;
            instance = new EaseIM();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized boolean init(Context context, EMOptions options) {
        if (this.sdkInited) {
            return true;
        }
        this.appContext = context.getApplicationContext();
        if (!this.isMainProcess(this.appContext)) {
            Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        if (options == null) {
            options = this.initChatOptions();
        }
        EMClient.getInstance().init(context, options);
        this.initNotifier();
        this.presenter = new EaseChatPresenter();
        this.presenter.attachApp(this.appContext);
        this.sdkInited = true;
        return true;
    }

    protected EMOptions initChatOptions() {
        Log.d((String)TAG, (String)"init HuanXin Options");
        EMOptions options = new EMOptions();
        options.setAcceptInvitationAlways(false);
        options.setRequireAck(true);
        options.setRequireDeliveryAck(false);
        return options;
    }

    public boolean isMainProcess(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            return context.getApplicationInfo().packageName.equals(appProcess.processName);
        }
        return false;
    }

    private void initNotifier() {
        this.notifier = new EaseNotifier(this.appContext);
    }

    public void addChatPresenter(EaseChatPresenter presenter) {
        this.presenter = presenter;
        this.presenter.attachApp(this.appContext);
    }

    public EaseChatPresenter getChatPresenter() {
        return this.presenter;
    }

    public EaseEmojiconInfoProvider getEmojiconInfoProvider() {
        return this.mEmojiconInfoProvider;
    }

    public EaseIM setEmojiconInfoProvider(EaseEmojiconInfoProvider emojiconInfoProvider) {
        this.mEmojiconInfoProvider = emojiconInfoProvider;
        return this;
    }

    public EaseSettingsProvider getSettingsProvider() {
        if (this.settingsProvider == null) {
            this.settingsProvider = this.getDefaultSettingsProvider();
        }
        return this.settingsProvider;
    }

    public EaseIM setSettingsProvider(EaseSettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
        return this;
    }

    public EaseUserProfileProvider getUserProvider() {
        return this.userProvider;
    }

    public EaseNotifier getNotifier() {
        return this.notifier;
    }

    public EaseIM setUserProvider(EaseUserProfileProvider userProvider) {
        this.userProvider = userProvider;
        return this;
    }

    public EaseAvatarOptions getAvatarOptions() {
        return this.avatarOptions;
    }

    public EaseIM setAvatarOptions(EaseAvatarOptions avatarOptions) {
        this.avatarOptions = avatarOptions;
        return this;
    }

    public EaseConversationInfoProvider getConversationInfoProvider() {
        return this.conversationInfoProvider;
    }

    public EaseIM setConversationInfoProvider(EaseConversationInfoProvider provider) {
        this.conversationInfoProvider = provider;
        return this;
    }

    public Context getContext() {
        return this.appContext;
    }

    private EaseSettingsProvider getDefaultSettingsProvider() {
        return new EaseSettingsProvider(){

            @Override
            public boolean isMsgNotifyAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isMsgSoundAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isMsgVibrateAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isSpeakerOpened() {
                return false;
            }
        };
    }
}

