/*
 * Decompiled with CFR 0.152.
 */
package io.github.nik9000.mapmatcher;

import io.github.nik9000.mapmatcher.MapMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ListMatcher
extends TypeSafeMatcher<List<?>> {
    private final List<Matcher<?>> matchers;

    public static ListMatcher matchesList() {
        return new ListMatcher(Collections.emptyList());
    }

    public static ListMatcher matchesList(List<?> list) {
        ListMatcher matcher = ListMatcher.matchesList();
        for (Object item : list) {
            matcher = matcher.item(item);
        }
        return matcher;
    }

    private ListMatcher(List<Matcher<?>> matchers) {
        this.matchers = matchers;
    }

    public ListMatcher item(Object value) {
        return this.item(MapMatcher.matcherFor(value));
    }

    public ListMatcher item(Matcher<?> valueMatcher) {
        ArrayList matchers = new ArrayList(this.matchers);
        matchers.add(valueMatcher);
        return new ListMatcher(matchers);
    }

    public void describeTo(Description description) {
        this.describeTo(this.keyWidth(Collections.emptyList()), description);
    }

    int keyWidth(List<?> item) {
        int max = Integer.toString(this.matchers.size()).length();
        Iterator<?> value = item.iterator();
        Iterator<Matcher<?>> matcher = this.matchers.iterator();
        while (matcher.hasNext()) {
            max = Math.max(max, MapMatcher.maxKeyWidthForMatcher(value.hasNext() ? value.next() : null, matcher.next()));
        }
        return max;
    }

    void describeTo(int keyWidth, Description description) {
        if (this.matchers.isEmpty()) {
            description.appendText("an empty list");
            return;
        }
        description.appendText("a list containing");
        int index = 0;
        for (Matcher<?> matcher : this.matchers) {
            MapMatcher.describeMatcher(keyWidth, index++, matcher, description);
        }
    }

    protected boolean matchesSafely(List<?> item) {
        if (item.size() != this.matchers.size()) {
            return false;
        }
        Iterator<?> value = item.iterator();
        Iterator<Matcher<?>> matcher = this.matchers.iterator();
        while (matcher.hasNext()) {
            if (matcher.next().matches(value.next())) continue;
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(List<?> item, Description description) {
        this.describePotentialMismatch(this.keyWidth(item), item, description);
    }

    void describePotentialMismatch(int keyWidth, List<?> item, Description description) {
        if (this.matchers.isEmpty()) {
            description.appendText("an empty list");
            return;
        }
        description.appendText("a list containing");
        int maxKeyWidth = Integer.toString(Math.max(item.size(), this.matchers.size())).length();
        String keyFormat = "%" + maxKeyWidth + "s";
        Iterator<?> value = item.iterator();
        Iterator<Matcher<?>> matcher = this.matchers.iterator();
        int index = 0;
        while (matcher.hasNext()) {
            MapMatcher.describeEntry(keyWidth, String.format(Locale.ROOT, keyFormat, index++), description);
            if (!value.hasNext()) {
                MapMatcher.describeEntryMissing(matcher.next(), description);
                continue;
            }
            MapMatcher.describeEntryValue(keyWidth, matcher.next(), value.next(), description);
        }
        while (value.hasNext()) {
            MapMatcher.describeEntry(keyWidth, String.format(Locale.ROOT, keyFormat, index++), description);
            MapMatcher.describeEntryUnexepected(value.next(), description);
        }
    }
}

