/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.os.SystemClock;
import androidx.annotation.WorkerThread;
import coil.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/util/FileDescriptorCounter;", "", "()V", "FILE_DESCRIPTOR_CHECK_INTERVAL_DECODES", "", "FILE_DESCRIPTOR_CHECK_INTERVAL_MILLIS", "FILE_DESCRIPTOR_LIMIT", "TAG", "", "decodesSinceLastFileDescriptorCheck", "fileDescriptorList", "Ljava/io/File;", "hasAvailableFileDescriptors", "", "lastFileDescriptorCheckTimestamp", "", "checkFileDescriptors", "logger", "Lcoil/util/Logger;", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nHardwareBitmaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardwareBitmaps.kt\ncoil/util/FileDescriptorCounter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 Logs.kt\ncoil/util/-Logs\n*L\n1#1,215:1\n18#2:216\n26#3:217\n21#4,4:218\n*S KotlinDebug\n*F\n+ 1 HardwareBitmaps.kt\ncoil/util/FileDescriptorCounter\n*L\n87#1:216\n87#1:217\n90#1:218,4\n*E\n"})
final class FileDescriptorCounter {
    @NotNull
    public static final FileDescriptorCounter INSTANCE = new FileDescriptorCounter();
    @NotNull
    private static final String TAG = "FileDescriptorCounter";
    private static final int FILE_DESCRIPTOR_LIMIT = 800;
    private static final int FILE_DESCRIPTOR_CHECK_INTERVAL_DECODES = 30;
    private static final int FILE_DESCRIPTOR_CHECK_INTERVAL_MILLIS = 30000;
    @NotNull
    private static final File fileDescriptorList = new File("/proc/self/fd");
    private static int decodesSinceLastFileDescriptorCheck = 30;
    private static long lastFileDescriptorCheckTimestamp = SystemClock.uptimeMillis();
    private static boolean hasAvailableFileDescriptors = true;

    private FileDescriptorCounter() {
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public final synchronized boolean hasAvailableFileDescriptors(@Nullable Logger logger) {
        block4: {
            int numUsedFileDescriptors;
            if (!this.checkFileDescriptors()) break block4;
            decodesSinceLastFileDescriptorCheck = 0;
            lastFileDescriptorCheckTimestamp = SystemClock.uptimeMillis();
            Object $this$orEmpty$iv = fileDescriptorList.list();
            boolean $i$f$orEmpty2 = false;
            String[] stringArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            }
            boolean bl = hasAvailableFileDescriptors = (numUsedFileDescriptors = stringArray.length) < 800;
            if (!hasAvailableFileDescriptors) {
                Logger logger2 = logger;
                if (logger2 != null) {
                    void $this$log$iv;
                    $this$orEmpty$iv = logger2;
                    String $i$f$orEmpty2 = TAG;
                    int priority$iv = 5;
                    boolean $i$f$log = false;
                    if ($this$log$iv.getLevel() <= priority$iv) {
                        void tag$iv;
                        int n = priority$iv;
                        void var9_9 = tag$iv;
                        void var8_10 = $this$log$iv;
                        boolean bl2 = false;
                        String string = "Unable to allocate more hardware bitmaps. Number of used file descriptors: " + numUsedFileDescriptors;
                        var8_10.log((String)var9_9, n, string, null);
                    }
                }
            }
        }
        return hasAvailableFileDescriptors;
    }

    private final boolean checkFileDescriptors() {
        int n = decodesSinceLastFileDescriptorCheck;
        decodesSinceLastFileDescriptorCheck = n + 1;
        return n >= 30 || SystemClock.uptimeMillis() > lastFileDescriptorCheckTimestamp + (long)30000;
    }
}

