/*
 * Decompiled with CFR 0.152.
 */
package coil.request;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.WorkerThread;
import androidx.lifecycle.Lifecycle;
import coil.ImageLoader;
import coil.request.BaseRequestDelegate;
import coil.request.CachePolicy;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.NullRequestDataException;
import coil.request.Options;
import coil.request.RequestDelegate;
import coil.request.ViewTargetRequestDelegate;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.target.Target;
import coil.target.ViewTarget;
import coil.util.-Bitmaps;
import coil.util.-HardwareBitmaps;
import coil.util.-Requests;
import coil.util.-Utils;
import coil.util.HardwareBitmapService;
import coil.util.Logger;
import coil.util.SystemCallbacks;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcoil/request/RequestService;", "", "imageLoader", "Lcoil/ImageLoader;", "systemCallbacks", "Lcoil/util/SystemCallbacks;", "logger", "Lcoil/util/Logger;", "(Lcoil/ImageLoader;Lcoil/util/SystemCallbacks;Lcoil/util/Logger;)V", "hardwareBitmapService", "Lcoil/util/HardwareBitmapService;", "allowHardwareWorkerThread", "", "options", "Lcoil/request/Options;", "errorResult", "Lcoil/request/ErrorResult;", "request", "Lcoil/request/ImageRequest;", "throwable", "", "isConfigValidForHardware", "requestedConfig", "Landroid/graphics/Bitmap$Config;", "isConfigValidForHardwareAllocation", "size", "Lcoil/size/Size;", "isConfigValidForTransformations", "requestDelegate", "Lcoil/request/RequestDelegate;", "initialRequest", "job", "Lkotlinx/coroutines/Job;", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestService.kt\ncoil/request/RequestService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class RequestService {
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final SystemCallbacks systemCallbacks;
    @NotNull
    private final HardwareBitmapService hardwareBitmapService;

    public RequestService(@NotNull ImageLoader imageLoader, @NotNull SystemCallbacks systemCallbacks, @Nullable Logger logger) {
        this.imageLoader = imageLoader;
        this.systemCallbacks = systemCallbacks;
        this.hardwareBitmapService = -HardwareBitmaps.HardwareBitmapService(logger);
    }

    @NotNull
    public final RequestDelegate requestDelegate(@NotNull ImageRequest initialRequest, @NotNull Job job2) {
        Lifecycle lifecycle = initialRequest.getLifecycle();
        Target target2 = initialRequest.getTarget();
        return target2 instanceof ViewTarget ? (RequestDelegate)new ViewTargetRequestDelegate(this.imageLoader, initialRequest, (ViewTarget)target2, lifecycle, job2) : (RequestDelegate)new BaseRequestDelegate(lifecycle, job2);
    }

    @NotNull
    public final ErrorResult errorResult(@NotNull ImageRequest request, @NotNull Throwable throwable) {
        Drawable drawable;
        if (throwable instanceof NullRequestDataException) {
            drawable = request.getFallback();
            if (drawable == null) {
                drawable = request.getError();
            }
        } else {
            drawable = request.getError();
        }
        return new ErrorResult(drawable, request, throwable);
    }

    @NotNull
    public final Options options(@NotNull ImageRequest request, @NotNull Size size2) {
        boolean isValidConfig = this.isConfigValidForTransformations(request) && this.isConfigValidForHardwareAllocation(request, size2);
        Bitmap.Config config = isValidConfig ? request.getBitmapConfig() : Bitmap.Config.ARGB_8888;
        CachePolicy networkCachePolicy = this.systemCallbacks.isOnline() ? request.getNetworkCachePolicy() : CachePolicy.DISABLED;
        Scale scale = Intrinsics.areEqual((Object)size2.getWidth(), (Object)Dimension.Undefined.INSTANCE) || Intrinsics.areEqual((Object)size2.getHeight(), (Object)Dimension.Undefined.INSTANCE) ? Scale.FIT : request.getScale();
        boolean allowRgb565 = request.getAllowRgb565() && request.getTransformations().isEmpty() && config != Bitmap.Config.ALPHA_8;
        return new Options(request.getContext(), config, request.getColorSpace(), size2, scale, -Requests.getAllowInexactSize(request), allowRgb565, request.getPremultipliedAlpha(), request.getDiskCacheKey(), request.getHeaders(), request.getTags(), request.getParameters(), request.getMemoryCachePolicy(), request.getDiskCachePolicy(), networkCachePolicy);
    }

    public final boolean isConfigValidForHardware(@NotNull ImageRequest request, @NotNull Bitmap.Config requestedConfig) {
        if (!-Bitmaps.isHardware(requestedConfig)) {
            return true;
        }
        if (!request.getAllowHardware()) {
            return false;
        }
        Target target2 = request.getTarget();
        if (target2 instanceof ViewTarget) {
            Object $this$isConfigValidForHardware_u24lambda_u240 = ((ViewTarget)target2).getView();
            boolean bl = false;
            boolean bl2 = $this$isConfigValidForHardware_u24lambda_u240.isAttachedToWindow() && !$this$isConfigValidForHardware_u24lambda_u240.isHardwareAccelerated();
            if (bl2) {
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    public final boolean allowHardwareWorkerThread(@NotNull Options options) {
        return !-Bitmaps.isHardware(options.getConfig()) || this.hardwareBitmapService.allowHardwareWorkerThread();
    }

    private final boolean isConfigValidForHardwareAllocation(ImageRequest request, Size size2) {
        if (!-Bitmaps.isHardware(request.getBitmapConfig())) {
            return true;
        }
        return this.isConfigValidForHardware(request, request.getBitmapConfig()) && this.hardwareBitmapService.allowHardwareMainThread(size2);
    }

    private final boolean isConfigValidForTransformations(ImageRequest request) {
        return request.getTransformations().isEmpty() || ArraysKt.contains((Object[])-Utils.getVALID_TRANSFORMATION_CONFIGS(), (Object)request.getBitmapConfig());
    }
}

