/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.os.Build;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.willowtreeapps.hyperion.attr.MutableBooleanViewAttribute;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.LayoutModeValue;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.List;

public class ViewGroupAttributeCollector
extends TypedAttributeCollector<ViewGroup> {
    public ViewGroupAttributeCollector() {
        super(ViewGroup.class);
    }

    @Override
    @NonNull
    public List<ViewAttribute> collect(final ViewGroup view, AttributeTranslator attributeTranslator) {
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        attributes.add(new ViewAttribute<Integer>("ChildCount", view.getChildCount()));
        attributes.add(new MutableBooleanViewAttribute("MotionEventSplittingEnabled", view.isMotionEventSplittingEnabled()){

            @Override
            protected void mutate(Boolean value) {
                view.setMotionEventSplittingEnabled(value.booleanValue());
            }
        });
        if (Build.VERSION.SDK_INT >= 18) {
            attributes.add(new ViewAttribute<LayoutModeValue>("LayoutMode", new LayoutModeValue(view.getLayoutMode())));
            attributes.add(new MutableBooleanViewAttribute("ClipChildren", view.getClipChildren()){

                @Override
                protected void mutate(Boolean value) {
                    view.setClipChildren(value.booleanValue());
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 21) {
            attributes.add(new MutableBooleanViewAttribute("ClipToPadding", view.getClipToPadding()){

                @Override
                protected void mutate(Boolean value) {
                    view.setClipToPadding(value.booleanValue());
                }
            });
            attributes.add(new ViewAttribute<Boolean>("TouchscreenBlocksFocus", view.getTouchscreenBlocksFocus()));
            attributes.add(new MutableBooleanViewAttribute("IsTransitionGroup", view.isTransitionGroup()){

                @Override
                @RequiresApi(api=21)
                protected void mutate(Boolean value) {
                    view.setTransitionGroup(value.booleanValue());
                }
            });
        }
        attributes.add(new ViewAttribute<Boolean>("DelayChildPressed", view.shouldDelayChildPressedState()));
        return attributes;
    }
}

