/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.widget.TextViewCompat;
import com.willowtreeapps.hyperion.attr.AttributeValue;
import com.willowtreeapps.hyperion.attr.MutableStringViewAttribute;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.Collectors;
import com.willowtreeapps.hyperion.attr.collectors.ColorValue;
import com.willowtreeapps.hyperion.attr.collectors.GravityValue;
import com.willowtreeapps.hyperion.attr.collectors.PorterDuffModeValue;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.List;

public class TextViewAttributeCollector
extends TypedAttributeCollector<TextView> {
    public TextViewAttributeCollector() {
        super(TextView.class);
    }

    @Override
    @NonNull
    public List<ViewAttribute> collect(final TextView view, AttributeTranslator attributeTranslator) {
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        attributes.add(new MutableStringViewAttribute("Text", view.getText().toString()){

            @Override
            protected void mutate(CharSequence value) {
                view.setText(value);
            }
        });
        attributes.add(new MutableStringViewAttribute("Hint", view.getHint()){

            @Override
            protected void mutate(CharSequence value) {
                view.setHint(value);
            }
        });
        attributes.add(new ViewAttribute<ColorValue>("TextColor", new ColorValue(view.getCurrentTextColor()), (Drawable)new ColorDrawable(view.getCurrentTextColor())));
        attributes.add(new ViewAttribute<ColorValue>("HintColor", new ColorValue(view.getCurrentHintTextColor()), (Drawable)new ColorDrawable(view.getCurrentHintTextColor())));
        attributes.add(new ViewAttribute<Typeface>("Typeface", view.getTypeface()));
        attributes.add(new ViewAttribute<String>("TextSize", attributeTranslator.translatePxToSp((int)view.getTextSize())));
        attributes.add(new ViewAttribute<Integer>("AutoSizeMaxTextSize", TextViewCompat.getAutoSizeMaxTextSize((TextView)view)));
        attributes.add(new ViewAttribute<Integer>("AutoSizeMinTextSize", TextViewCompat.getAutoSizeMinTextSize((TextView)view)));
        attributes.add(new ViewAttribute<Integer>("AutoSizeStepGranularity", TextViewCompat.getAutoSizeStepGranularity((TextView)view)));
        attributes.add(new ViewAttribute<GravityValue>("Gravity", new GravityValue(view.getGravity())));
        attributes.add(new ViewAttribute<Integer>("ImeAction", view.getImeActionId()));
        attributes.add(new ViewAttribute<CharSequence>("ImeActionLabel", view.getImeActionLabel()));
        attributes.add(new ViewAttribute<ImeOptionsValue>("ImeOptions", new ImeOptionsValue(view.getImeOptions())));
        attributes.add(new ViewAttribute<String>("CompoundPaddingLeft", attributeTranslator.translatePx(view.getCompoundPaddingLeft())));
        attributes.add(new ViewAttribute<String>("CompoundPaddingTop", attributeTranslator.translatePx(view.getCompoundPaddingTop())));
        attributes.add(new ViewAttribute<String>("CompoundPaddingRight", attributeTranslator.translatePx(view.getCompoundPaddingRight())));
        attributes.add(new ViewAttribute<String>("CompoundPaddingBottom", attributeTranslator.translatePx(view.getCompoundPaddingBottom())));
        attributes.add(new ViewAttribute<String>("CompoundDrawable", attributeTranslator.translatePx(view.getCompoundDrawablePadding())));
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(Collectors.createColorAttribute((View)view, "CompoundDrawableTint", view.getCompoundDrawableTintList()));
            attributes.add(new ViewAttribute<PorterDuffModeValue>("CompoundDrawableTintMode", new PorterDuffModeValue(view.getCompoundDrawableTintMode())));
        }
        return attributes;
    }

    private static class ImeOptionsValue
    implements AttributeValue {
        private final int imeOptions;

        private ImeOptionsValue(int imeOptions) {
            this.imeOptions = imeOptions;
        }

        @Override
        public CharSequence getDisplayValue() {
            StringBuilder sb = new StringBuilder();
            if (this.imeOptions == 0) {
                sb.append("UNSPECIFIED|");
            }
            if ((this.imeOptions & 6) == 6) {
                sb.append("DONE|");
            }
            if ((this.imeOptions & 2) == 2) {
                sb.append("GO|");
            }
            if ((this.imeOptions & 5) == 5) {
                sb.append("NEXT|");
            }
            if ((this.imeOptions & 1) == 1) {
                sb.append("NONE|");
            }
            if ((this.imeOptions & 7) == 7) {
                sb.append("PREVIOUS|");
            }
            if ((this.imeOptions & 3) == 3) {
                sb.append("SEARCH|");
            }
            if ((this.imeOptions & 4) == 4) {
                sb.append("SEND|");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
    }
}

