/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;
import android.widget.Switch;
import androidx.annotation.NonNull;
import com.willowtreeapps.hyperion.attr.MutableBooleanViewAttribute;
import com.willowtreeapps.hyperion.attr.MutableStringViewAttribute;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.Collectors;
import com.willowtreeapps.hyperion.attr.collectors.PorterDuffModeValue;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.List;

public class SwitchAttributeCollector
extends TypedAttributeCollector<Switch> {
    public SwitchAttributeCollector() {
        super(Switch.class);
    }

    @Override
    @NonNull
    public List<ViewAttribute> collect(final Switch view, AttributeTranslator attributeTranslator) {
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        attributes.add(new MutableStringViewAttribute("TextOn", view.getTextOn()){

            @Override
            protected void mutate(CharSequence value) {
                view.setTextOn(value);
            }
        });
        attributes.add(new MutableStringViewAttribute("TextOff", view.getTextOff()){

            @Override
            protected void mutate(CharSequence value) {
                view.setTextOff(value);
            }
        });
        if (Build.VERSION.SDK_INT >= 21) {
            attributes.add(new MutableBooleanViewAttribute("ShowText", view.getShowText()){

                @Override
                @TargetApi(value=21)
                protected void mutate(Boolean value) {
                    view.setShowText(value.booleanValue());
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 16) {
            attributes.add(new ViewAttribute<String>("SwitchPadding", attributeTranslator.translatePx(view.getSwitchPadding())));
            attributes.add(new ViewAttribute<String>("SwitchMinWidth", attributeTranslator.translatePx(view.getSwitchMinWidth())));
            attributes.add(new ViewAttribute<String>("ThumbTextPadding", attributeTranslator.translatePx(view.getThumbTextPadding())));
            attributes.add(new ViewAttribute("ThumbDrawable", view.getThumbDrawable()));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(Collectors.createColorAttribute((View)view, "ThumbTint", view.getThumbTintList()));
            attributes.add(new ViewAttribute<PorterDuffModeValue>("ThumbTintMode", new PorterDuffModeValue(view.getThumbTintMode())));
        }
        if (Build.VERSION.SDK_INT >= 16) {
            attributes.add(new ViewAttribute("TrackDrawable", view.getTrackDrawable()));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            attributes.add(Collectors.createColorAttribute((View)view, "TrackTint", view.getTrackTintList()));
            attributes.add(new ViewAttribute<PorterDuffModeValue>("TrackTintMode", new PorterDuffModeValue(view.getTrackTintMode())));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            attributes.add(new MutableBooleanViewAttribute("SplitTrack", view.getSplitTrack()){

                @Override
                @TargetApi(value=21)
                protected void mutate(Boolean value) {
                    view.setSplitTrack(value.booleanValue());
                }
            });
        }
        return attributes;
    }
}

