/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr.collectors;

import android.os.Build;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.willowtreeapps.hyperion.attr.AttributeValue;
import com.willowtreeapps.hyperion.attr.MutableBooleanViewAttribute;
import com.willowtreeapps.hyperion.attr.MutableStringViewAttribute;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.attr.collectors.GravityValue;
import com.willowtreeapps.hyperion.attr.collectors.TypedAttributeCollector;
import com.willowtreeapps.hyperion.plugin.v1.AttributeTranslator;
import java.util.ArrayList;
import java.util.List;

public class LinearLayoutAttributeCollector
extends TypedAttributeCollector<LinearLayout> {
    public LinearLayoutAttributeCollector() {
        super(LinearLayout.class);
    }

    @Override
    @NonNull
    public List<ViewAttribute> collect(final LinearLayout view, AttributeTranslator attributeTranslator) {
        ArrayList<ViewAttribute> attributes = new ArrayList<ViewAttribute>();
        attributes.add(new ViewAttribute<OrientationValue>("Orientation", new OrientationValue(view.getOrientation())));
        attributes.add(new ViewAttribute<Float>("WeightSum", Float.valueOf(view.getWeightSum())));
        if (Build.VERSION.SDK_INT >= 24) {
            attributes.add(new ViewAttribute<GravityValue>("Gravity", new GravityValue(view.getGravity())));
        }
        attributes.add(new ViewAttribute<DividerModeValue>("ShowDividers", new DividerModeValue(view.getShowDividers())));
        if (Build.VERSION.SDK_INT >= 16) {
            attributes.add(new ViewAttribute("Divider", view.getDividerDrawable()));
        }
        attributes.add(new ViewAttribute<String>("DividerPadding", attributeTranslator.translatePx(view.getDividerPadding())));
        attributes.add(new MutableBooleanViewAttribute("MeasureWithLargestChild", view.isMeasureWithLargestChildEnabled()){

            @Override
            protected void mutate(Boolean value) throws Exception {
                view.setMeasureWithLargestChildEnabled(value.booleanValue());
            }
        });
        attributes.add(new MutableBooleanViewAttribute("BaselineAligned", view.isBaselineAligned()){

            @Override
            protected void mutate(Boolean value) throws Exception {
                view.setBaselineAligned(value.booleanValue());
            }
        });
        attributes.add(new MutableStringViewAttribute("BaselineAlignedChildIndex", String.valueOf(view.getBaselineAlignedChildIndex())){

            @Override
            protected void mutate(CharSequence value) throws Exception {
                int index = Integer.parseInt(value.toString());
                view.setBaselineAlignedChildIndex(index);
            }
        });
        return attributes;
    }

    private static class DividerModeValue
    implements AttributeValue {
        private final int mode;

        private DividerModeValue(int mode) {
            this.mode = mode;
        }

        @Override
        public CharSequence getDisplayValue() {
            switch (this.mode) {
                case 0: {
                    return "None";
                }
                case 1: {
                    return "Beginning";
                }
                case 2: {
                    return "Middle";
                }
                case 4: {
                    return "End";
                }
            }
            return "Unknown";
        }
    }

    private static class OrientationValue
    implements AttributeValue {
        private final int mode;

        private OrientationValue(int mode) {
            this.mode = mode;
        }

        @Override
        public CharSequence getDisplayValue() {
            switch (this.mode) {
                case 0: {
                    return "Horizontal";
                }
                case 1: {
                    return "Vertical";
                }
            }
            return "Unknown";
        }
    }
}

