/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.willowtreeapps.hyperion.attr.AttributeDetailItem;
import com.willowtreeapps.hyperion.attr.AttributeValue;

public class ViewAttribute<T>
implements AttributeDetailItem {
    private final String key;
    @Nullable
    protected T value;
    @Nullable
    private final Drawable drawable;

    public ViewAttribute(String key, @Nullable T value) {
        this.key = key;
        this.value = value;
        this.drawable = null;
    }

    public ViewAttribute(String key, @Nullable Drawable drawable) {
        this.key = key;
        this.value = null;
        this.drawable = drawable;
    }

    public ViewAttribute(String key, @NonNull T value, @Nullable Drawable drawable) {
        this.key = key;
        this.value = value;
        this.drawable = drawable;
    }

    String getKey() {
        return this.key;
    }

    @NonNull
    CharSequence getDisplayValue() {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof AttributeValue) {
            return ((AttributeValue)this.value).getDisplayValue();
        }
        return this.value.toString();
    }

    @Nullable
    Drawable getDrawable() {
        if (this.drawable == null) {
            return null;
        }
        return this.drawable.mutate();
    }

    @Override
    public int getViewType() {
        return 2;
    }
}

