/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.attr;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.willowtreeapps.hyperion.attr.AttributeDetailItem;
import com.willowtreeapps.hyperion.attr.AttributeLoader;
import com.willowtreeapps.hyperion.attr.DataViewHolder;
import com.willowtreeapps.hyperion.attr.ExpandableLayout;
import com.willowtreeapps.hyperion.attr.Header;
import com.willowtreeapps.hyperion.attr.MutableBooleanViewAttribute;
import com.willowtreeapps.hyperion.attr.MutableStringViewAttribute;
import com.willowtreeapps.hyperion.attr.R;
import com.willowtreeapps.hyperion.attr.Section;
import com.willowtreeapps.hyperion.attr.ViewAttribute;
import com.willowtreeapps.hyperion.plugin.v1.ExtensionProvider;
import com.willowtreeapps.hyperion.plugin.v1.PluginExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AttributeDetailView
extends RecyclerView {
    static final int ITEM_HEADER = 1;
    static final int ITEM_ATTRIBUTE = 2;
    static final int ITEM_MUTABLE_COLOR_ATTRIBUTE = 3;
    static final int ITEM_MUTABLE_STRING_ATTRIBUTE = 4;
    static final int ITEM_MUTABLE_BOOLEAN_ATTRIBUTE = 5;
    private final AttributeAdapter adapter;
    private final AttributeLoader attributeLoader;

    public AttributeDetailView(@NonNull Context context) {
        this(context, null);
    }

    public AttributeDetailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AttributeDetailView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PluginExtension extension = ExtensionProvider.get((Context)context);
        this.adapter = new AttributeAdapter();
        this.attributeLoader = new AttributeLoader(extension.getAttributeTranslator());
        this.setHasFixedSize(true);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setAdapter(this.adapter);
        DividerItemDecoration decoration = new DividerItemDecoration(context, 1);
        decoration.setDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ha_detail_divider));
        this.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }

    public void setTarget(View target) {
        if (target != null) {
            List<Section<ViewAttribute>> sections = this.attributeLoader.getAttributesForView(target);
            List<AttributeDetailItem> items = this.toItems(sections);
            this.adapter.setItems(items);
        } else {
            this.adapter.setItems(Collections.emptyList());
        }
    }

    private List<AttributeDetailItem> toItems(List<Section<ViewAttribute>> sections) {
        ArrayList<AttributeDetailItem> items = new ArrayList<AttributeDetailItem>(18);
        for (Section<ViewAttribute> section : sections) {
            items.add(new Header(section.getName()));
            items.addAll(section.getList());
        }
        return items;
    }

    private static class MutableBooleanAttributeViewHolder
    extends DataViewHolder<MutableBooleanViewAttribute>
    implements View.OnClickListener {
        private final TextView keyText;
        private final Switch booleanSwitch;

        private MutableBooleanAttributeViewHolder(View itemView) {
            super(itemView);
            this.keyText = (TextView)itemView.findViewById(R.id.key_text);
            this.booleanSwitch = (Switch)itemView.findViewById(R.id.boolean_switch);
            this.booleanSwitch.setOnClickListener((View.OnClickListener)this);
        }

        @Override
        void onDataChanged(MutableBooleanViewAttribute data) {
            this.keyText.setText((CharSequence)data.getKey());
            this.booleanSwitch.setChecked(data.getBoolean());
        }

        public void onClick(View v) {
            MutableBooleanViewAttribute attribute = (MutableBooleanViewAttribute)this.getData();
            attribute.setValue(this.booleanSwitch.isChecked());
        }
    }

    private static class MutableStringAttributeViewHolder
    extends AttributeViewHolder<MutableStringViewAttribute>
    implements View.OnClickListener,
    TextWatcher {
        private final ExpandableLayout detail;
        private final EditText editText;

        private MutableStringAttributeViewHolder(View itemView) {
            super(itemView);
            this.detail = (ExpandableLayout)itemView.findViewById(R.id.detail);
            this.editText = (EditText)itemView.findViewById(R.id.edit_text);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            MutableStringViewAttribute attribute = (MutableStringViewAttribute)this.getData();
            boolean activated = !attribute.isActivated();
            attribute.setActivated(activated);
            this.itemView.setActivated(activated);
            this.detail.setExpanded(activated);
        }

        @Override
        void onDataChanged(MutableStringViewAttribute data) {
            super.onDataChanged((Object)data);
            boolean activated = data.isActivated();
            this.itemView.setActivated(activated);
            this.detail.setExpanded(activated, false);
            this.editText.removeTextChangedListener((TextWatcher)this);
            this.editText.setText(data.getDisplayValue());
            this.editText.addTextChangedListener((TextWatcher)this);
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            MutableStringViewAttribute attribute = (MutableStringViewAttribute)this.getData();
            String value = s.toString();
            attribute.setValue(value);
            this.valueText.setText((CharSequence)value);
            this.valueText.setVisibility(0);
        }
    }

    private static class AttributeViewHolder<T extends ViewAttribute>
    extends DataViewHolder<T> {
        private final TextView keyText;
        final TextView valueText;
        private final ImageView image;

        private AttributeViewHolder(View itemView) {
            super(itemView);
            this.keyText = (TextView)itemView.findViewById(R.id.key_text);
            this.valueText = (TextView)itemView.findViewById(R.id.value_text);
            this.image = (ImageView)itemView.findViewById(R.id.image);
        }

        @Override
        void onDataChanged(ViewAttribute data) {
            this.keyText.setText((CharSequence)data.getKey());
            this.valueText.setText(data.getDisplayValue());
            Drawable drawable2 = data.getDrawable();
            if (drawable2 != null) {
                this.image.setImageDrawable(drawable2);
                this.image.setVisibility(0);
            } else {
                this.image.setVisibility(8);
            }
        }
    }

    private static class HeaderViewHolder
    extends DataViewHolder<Header> {
        private final TextView text;

        private HeaderViewHolder(View itemView) {
            super(itemView);
            this.text = (TextView)itemView.findViewById(R.id.text);
        }

        @Override
        void onDataChanged(Header data) {
            this.text.setText((CharSequence)data.getText());
        }
    }

    private static class AttributeAdapter
    extends RecyclerView.Adapter<DataViewHolder> {
        private List<AttributeDetailItem> items;

        private AttributeAdapter() {
        }

        private void setItems(List<AttributeDetailItem> items) {
            this.items = items;
            this.notifyDataSetChanged();
        }

        @NonNull
        public DataViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            switch (viewType) {
                case 1: {
                    View itemView = inflater.inflate(R.layout.ha_item_header, parent, false);
                    return new HeaderViewHolder(itemView);
                }
                case 2: {
                    View itemView = inflater.inflate(R.layout.ha_item_attribute, parent, false);
                    return new AttributeViewHolder(itemView);
                }
                case 4: {
                    View itemView = inflater.inflate(R.layout.ha_item_mutable_string_attribute, parent, false);
                    return new MutableStringAttributeViewHolder(itemView);
                }
                case 5: {
                    View itemView = inflater.inflate(R.layout.ha_item_mutable_boolean_attribute, parent, false);
                    return new MutableBooleanAttributeViewHolder(itemView);
                }
            }
            throw new IllegalStateException("Did not recognize view type: " + viewType);
        }

        public void onBindViewHolder(@NonNull DataViewHolder holder, int position) {
            holder.bind(this.items.get(position));
        }

        public int getItemCount() {
            return this.items == null ? 0 : this.items.size();
        }

        public int getItemViewType(int position) {
            return this.items.get(position).getViewType();
        }
    }
}

