/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.libpag.SynchronizeHandler;
import org.libpag.VideoSurface;

public class GPUDecoder {
    private static final int SUCCESS = 0;
    private static final int TRY_AGAIN_LATER = -1;
    private static final int ERROR = -2;
    private static final int END_OF_STREAM = -3;
    private VideoSurface videoSurface = null;
    private MediaCodec decoder;
    private boolean disableFlush = true;
    private static final int INIT_DECODER_TIMEOUT_MS = 2000;
    private static final int DECODER_THREAD_MAX_COUNT = 10;
    private static final AtomicInteger decoderThreadCount = new AtomicInteger();
    private MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private static final int TIMEOUT_US = 1000;
    private int lastOutputBufferIndex = -1;
    private boolean released = false;

    private static boolean ForceSoftwareDecoder() {
        return Build.VERSION.SDK_INT < 21;
    }

    private static GPUDecoder Create(final VideoSurface videoSurface, final MediaFormat mediaFormat) {
        if (videoSurface == null || decoderThreadCount.get() >= 10) {
            return null;
        }
        videoSurface.retain();
        decoderThreadCount.getAndIncrement();
        HandlerThread initHandlerThread = new HandlerThread("libpag_GPUDecoder_init_decoder");
        initHandlerThread.start();
        SynchronizeHandler initHandler = new SynchronizeHandler(initHandlerThread.getLooper());
        final MediaCodec[] initDecoder = new MediaCodec[]{null};
        boolean res = initHandler.runSync(new SynchronizeHandler.TimeoutRunnable(){
            private MediaCodec decoder;
            private long startTime;

            @Override
            public void run() {
                block2: {
                    this.startTime = SystemClock.uptimeMillis();
                    try {
                        this.decoder = MediaCodec.createDecoderByType((String)mediaFormat.getString("mime"));
                        this.decoder.configure(mediaFormat, videoSurface.getOutputSurface(), null, 0);
                        this.decoder.start();
                    }
                    catch (Exception e) {
                        if (this.decoder == null) break block2;
                        this.decoder.release();
                        this.decoder = null;
                        videoSurface.release();
                    }
                }
            }

            @Override
            public void afterRun(boolean isTimeout) {
                if (isTimeout && this.decoder != null) {
                    long costTime = SystemClock.uptimeMillis() - this.startTime;
                    try {
                        this.decoder.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.decoder.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.decoder = null;
                    videoSurface.release();
                    String errorMessage = "init decoder timeout. cost: " + costTime + "ms";
                    new RuntimeException(errorMessage).printStackTrace();
                }
                if (!isTimeout) {
                    initDecoder[0] = this.decoder;
                }
                decoderThreadCount.getAndDecrement();
            }
        }, 2000L);
        initHandlerThread.quitSafely();
        if (res) {
            GPUDecoder decoder = new GPUDecoder();
            decoder.videoSurface = videoSurface;
            decoder.decoder = initDecoder[0];
            return decoder;
        }
        return null;
    }

    private int dequeueOutputBuffer() {
        try {
            return this.decoder.dequeueOutputBuffer(this.bufferInfo, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int dequeueInputBuffer() {
        try {
            return this.decoder.dequeueInputBuffer(1000L);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private ByteBuffer getInputBuffer(int inputBufferIndex) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                return this.decoder.getInputBuffer(inputBufferIndex);
            }
            return this.decoder.getInputBuffers()[inputBufferIndex];
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int queueInputBuffer(int inputBufferIndex, int offset, int size, long presentationTimeUs, int flag) {
        try {
            this.decoder.queueInputBuffer(inputBufferIndex, offset, size, presentationTimeUs, flag);
            this.disableFlush = false;
            return 0;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    private void releaseOutputBuffer() {
        if (this.lastOutputBufferIndex != -1) {
            this.releaseOutputBuffer(this.lastOutputBufferIndex, false);
            this.lastOutputBufferIndex = -1;
        }
    }

    private int releaseOutputBuffer(int outputBufferIndex, boolean render) {
        try {
            this.decoder.releaseOutputBuffer(outputBufferIndex, render);
            return 0;
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    private int onSendBytes(ByteBuffer bytes, long frame) {
        int inputBufferIndex = this.dequeueInputBuffer();
        if (inputBufferIndex >= 0) {
            ByteBuffer inputBuffer = this.getInputBuffer(inputBufferIndex);
            if (inputBuffer == null) {
                return -2;
            }
            inputBuffer.clear();
            bytes.position(0);
            inputBuffer.put(bytes);
            return this.queueInputBuffer(inputBufferIndex, 0, bytes.limit(), frame, 0);
        }
        return -1;
    }

    private int onEndOfStream() {
        int inputBufferIndex = this.dequeueInputBuffer();
        if (inputBufferIndex >= 0) {
            return this.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
        }
        return -1;
    }

    private int onDecodeFrame() {
        this.releaseOutputBuffer();
        try {
            int outputBufferIndex = this.dequeueOutputBuffer();
            if ((this.bufferInfo.flags & 4) != 0) {
                if (outputBufferIndex >= 0) {
                    this.lastOutputBufferIndex = outputBufferIndex;
                }
                return -3;
            }
            if (outputBufferIndex >= 0) {
                this.lastOutputBufferIndex = outputBufferIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
        return this.lastOutputBufferIndex != -1 ? 0 : -1;
    }

    private void onFlush() {
        if (this.disableFlush) {
            return;
        }
        try {
            this.decoder.flush();
            this.bufferInfo = new MediaCodec.BufferInfo();
            this.lastOutputBufferIndex = -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long presentationTime() {
        return this.bufferInfo.presentationTimeUs;
    }

    private boolean onRenderFrame() {
        if (this.lastOutputBufferIndex != -1) {
            int success = this.releaseOutputBuffer(this.lastOutputBufferIndex, true);
            this.lastOutputBufferIndex = -1;
            return success == 0;
        }
        return false;
    }

    private void onRelease() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.releaseOutputBuffer();
        this.releaseDecoder();
    }

    private void releaseDecoder() {
        if (this.decoder == null) {
            return;
        }
        this.releaseAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    GPUDecoder.this.decoder.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    GPUDecoder.this.decoder.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GPUDecoder.this.decoder = null;
                GPUDecoder.this.videoSurface.release();
            }
        });
    }

    private void releaseAsync(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        decoderThreadCount.getAndIncrement();
        final HandlerThread releaseHandlerThread = new HandlerThread("libpag_GPUDecoder_release_decoder");
        releaseHandlerThread.start();
        Handler releaseHandler = new Handler(releaseHandlerThread.getLooper());
        releaseHandler.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                decoderThreadCount.getAndDecrement();
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        releaseHandlerThread.quitSafely();
                    }
                });
            }
        });
    }
}

