/*
 * Decompiled with CFR 0.152.
 */
package org.extra.tools;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.extra.tools.LifecycleFragment;
import org.libpag.PAGView;

public class Lifecycle
implements Handler.Callback {
    private static final String FRAGMENT_TAG = "io.pag.manager";
    private static final String TAG = "Lifecycle";
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final Lifecycle lifecycle = new Lifecycle();
    private final Handler handler;
    private final Map<FragmentManager, LifecycleFragment> pendingRequestManagerFragments = new HashMap<FragmentManager, LifecycleFragment>();

    private Lifecycle() {
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Lifecycle getInstance() {
        return lifecycle;
    }

    public void addListener(PAGView pagView) {
        if (pagView.getContext() instanceof Activity) {
            Activity activity = (Activity)pagView.getContext();
            FragmentManager fm = activity.getFragmentManager();
            LifecycleFragment current = this.pendingRequestManagerFragments.get(fm);
            if (current == null && (current = (LifecycleFragment)fm.findFragmentByTag(FRAGMENT_TAG)) == null) {
                current = new LifecycleFragment();
                this.pendingRequestManagerFragments.put(fm, current);
                fm.beginTransaction().add((Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
                this.handler.obtainMessage(1, (Object)fm).sendToTarget();
            }
            current.addListener(pagView);
        }
    }

    public boolean handleMessage(Message message) {
        boolean handled = true;
        if (message.what == 1) {
            FragmentManager fm = (FragmentManager)message.obj;
            LifecycleFragment current = (LifecycleFragment)fm.findFragmentByTag(FRAGMENT_TAG);
            if (fm.isDestroyed()) {
                Log.w((String)TAG, (String)"Parent was destroyed before our Fragment could be added.");
            } else if (current != this.pendingRequestManagerFragments.get(fm)) {
                Log.w((String)TAG, (String)"adding Fragment failed.");
            }
            this.pendingRequestManagerFragments.remove(fm);
        } else {
            handled = false;
        }
        return handled;
    }
}

