/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.Context;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorEarReturnClient;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorAudioServiceCallback;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorHonor
implements IHonorAudioServiceCallback {
    private long mNativeHardwareEarMonitorHandle = 0L;
    private Context mContext;
    private Object mLock = new Object();
    private HonorAudioClient mHnAudioClient;
    private HonorEarReturnClient mHnEarReturnClient;

    public static HardwareEarMonitorHonor create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorHonor(nativeHardwareEarMonitorHandle);
    }

    public static boolean isAudioKitSupport() {
        return HonorAudioClient.isDeviceSupported(ContextUtils.getApplicationContext());
    }

    public boolean isKaraokeServiceSupport() {
        return this.mHnAudioClient.isServiceSupported(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN);
    }

    public void createKaraokeService() {
        this.mHnEarReturnClient = (HonorEarReturnClient)this.mHnAudioClient.createService(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
        }
        if (this.mHnAudioClient != null) {
            this.mHnAudioClient.destroy();
            this.mHnAudioClient = null;
        }
        if (this.mHnEarReturnClient != null) {
            this.mHnEarReturnClient.destroy();
            this.mHnEarReturnClient = null;
        }
    }

    public boolean enableKaraoke(boolean enable) {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.enableEarReturn(enable) == 0;
    }

    public boolean setReverberation(int value) {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_AUDIO_EFFECT_MODE_BASE, value) == 0;
    }

    public boolean setEqualizer(int value) {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_VOCAL_EQUALIZER_MODE, value) == 0;
    }

    public boolean setVolume(int value) {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_VOCAL_VOLUME_BASE, value) == 0;
    }

    public boolean isHardwareEarMonitorSupported() {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.isServiceSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(int resultType) {
        Object object = this.mLock;
        synchronized (object) {
            HardwareEarMonitorHonor.nativeHandleResult(this.mNativeHardwareEarMonitorHandle, resultType);
            return;
        }
    }

    public HardwareEarMonitorHonor(long nativeSystemAudioKit) {
        this.mNativeHardwareEarMonitorHandle = nativeSystemAudioKit;
        this.mContext = ContextUtils.getApplicationContext();
        this.mHnAudioClient = new HonorAudioClient(this.mContext, this);
        this.mHnAudioClient.initialize();
    }

    private static native void nativeHandleResult(long var0, int var2);
}

