/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.private_constructor_checker;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PrivateConstructorChecker {
    private final List<Class> classes;
    private final Class<? extends Throwable> expectedTypeOfException;
    private final String expectedExceptionMessage;
    private Class[] expectedParameters;

    private PrivateConstructorChecker(List<Class> classes, Class<? extends Throwable> expectedTypeOfException, String expectedExceptionMessage, Class[] expectedParameters) {
        this.classes = classes;
        this.expectedTypeOfException = expectedTypeOfException;
        this.expectedExceptionMessage = expectedExceptionMessage;
        this.expectedParameters = expectedParameters;
    }

    public static Builder forClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        return new Builder(Collections.singletonList(clazz));
    }

    public static Builder forClasses(Class ... classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("classes can not be null or empty");
        }
        for (Class clazz : classes) {
            if (clazz != null) continue;
            throw new IllegalArgumentException("class can not be null");
        }
        return new Builder(Collections.unmodifiableList(Arrays.asList(classes)));
    }

    public void check() {
        for (Class clazz : this.classes) {
            this.check(clazz);
        }
    }

    private void check(Class clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length > 1) {
            throw new AssertionError((Object)(clazz + " has more than one constructor"));
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        if (!Modifier.isPrivate(constructor.getModifiers())) {
            throw new AssertionError((Object)("Constructor of " + clazz + " must be private"));
        }
        Object[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length > 0) {
            if (this.expectedParameters == null) {
                throw new AssertionError((Object)(clazz + " has non-default constructor with some parameters"));
            }
            if (!Arrays.equals(parameterTypes, this.expectedParameters)) {
                throw new AssertionError((Object)("Expected constructor with parameters " + PrivateConstructorChecker.getReadableClassesOutput(this.expectedParameters) + " but found constructor with parameters " + PrivateConstructorChecker.getReadableClassesOutput(parameterTypes)));
            }
            return;
        }
        try {
            constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Can not instantiate instance of " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (this.expectedTypeOfException != null || this.expectedExceptionMessage != null) {
                if (this.expectedTypeOfException != null && !this.expectedTypeOfException.equals(cause.getClass())) {
                    throw new IllegalStateException("For " + clazz + " expected exception of type = " + this.expectedTypeOfException + ", but was exception of type = " + e.getCause().getClass());
                }
                if (this.expectedExceptionMessage != null && !this.expectedExceptionMessage.equals(cause.getMessage())) {
                    throw new IllegalStateException("For " + clazz + " expected exception message = '" + this.expectedExceptionMessage + "', but was = '" + cause.getMessage() + "'", e.getCause());
                }
            }
            throw new IllegalStateException("For " + clazz + " no exception was expected", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Looks like constructor of " + clazz + " is not default", e);
        }
    }

    private static String getReadableClassesOutput(Class<?>[] classes) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (classes.length > 0) {
            String concatenator = ", ";
            for (Class<?> clazz : classes) {
                stringBuilder.append(clazz.getSimpleName()).append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - ", ".length());
        }
        return stringBuilder.append(')').toString();
    }

    public static class Builder
    implements ExceptionCheckable,
    ParametersCheckable {
        private final List<Class> classes;
        private Class<? extends Throwable> expectedTypeOfException;
        private String expectedExceptionMessage;
        private Class[] expectedParameters;

        Builder(List<Class> classes) {
            this.classes = classes;
        }

        @Override
        public ExceptionCheckable expectedTypeOfException(Class<? extends Throwable> expectedTypeOfException) {
            if (expectedTypeOfException == null) {
                throw new IllegalArgumentException("expectedTypeOfException can not be null");
            }
            this.expectedTypeOfException = expectedTypeOfException;
            return this;
        }

        @Override
        public ExceptionCheckable expectedExceptionMessage(String expectedExceptionMessage) {
            if (expectedExceptionMessage == null) {
                throw new IllegalArgumentException("expectedExceptionMessage can not be null");
            }
            this.expectedExceptionMessage = expectedExceptionMessage;
            return this;
        }

        @Override
        public ParametersCheckable expectedWithParameters(Class<?> ... expectedParameters) {
            if (expectedParameters == null) {
                throw new IllegalArgumentException("expectedParameters can not be null");
            }
            this.expectedParameters = expectedParameters;
            return this;
        }

        @Override
        public void check() {
            new PrivateConstructorChecker(this.classes, this.expectedTypeOfException, this.expectedExceptionMessage, this.expectedParameters).check();
        }
    }

    public static interface ParametersCheckable
    extends Checkable {
        public ParametersCheckable expectedWithParameters(Class<?> ... var1);
    }

    public static interface ExceptionCheckable
    extends Checkable {
        public ExceptionCheckable expectedExceptionMessage(String var1);

        public ExceptionCheckable expectedTypeOfException(Class<? extends Throwable> var1);
    }

    public static interface Checkable {
        public void check();
    }
}

