/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option;

import com.perforce.p4java.PropertyDefs;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import java.util.Properties;

public class UsageOptions {
    public static final String WORKING_DIRECTORY_PROPNAME = "user.dir";
    protected Properties props = null;
    protected String programName = null;
    protected String programVersion = null;
    protected String workingDirectory = null;
    protected String hostName = null;
    protected String textLanguage = null;
    protected String unsetUserName = null;
    protected String unsetClientName = null;
    protected String defaultWorkingDirectory = null;

    public UsageOptions(Properties props) {
        this.props = props == null ? new Properties() : props;
        this.setFieldDefaults(this.getProps());
    }

    public UsageOptions(Properties props, String programName, String programVersion, String workingDirectory, String hostName, String textLanguage, String unsetUserName, String noClientName) {
        this.props = props == null ? new Properties() : props;
        this.programName = programName;
        this.programVersion = programVersion;
        this.workingDirectory = workingDirectory;
        this.hostName = hostName;
        this.textLanguage = textLanguage;
        this.unsetUserName = unsetUserName;
        this.unsetClientName = noClientName;
        this.setFieldDefaults(this.getProps());
    }

    protected void setFieldDefaults(Properties props) {
        this.defaultWorkingDirectory = this.getWorkingDirectoryDefault(props);
    }

    protected String getProgramNameDefault(Properties props) {
        if (props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return props.getProperty("programName", props.getProperty("com.perforce.p4java.programName", "Unknown P4Java program"));
    }

    protected String getProgramVersionDefault(Properties props) {
        if (props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return props.getProperty("programVersion", props.getProperty("com.perforce.p4java.programVersion", PropertyDefs.PROG_VERSION_DEFAULT));
    }

    protected String getWorkingDirectoryDefault(Properties props) {
        String cwd = System.getProperty(WORKING_DIRECTORY_PROPNAME);
        if (cwd == null) {
            throw new P4JavaError("Unable to retrieve current working directory from JVM system properties");
        }
        return cwd;
    }

    protected String getUnsetUserNameDefault(Properties props) {
        if (props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("com.perforce.p4java.unsetUserName", "nouser");
    }

    protected String getUnsetClientNameDefault(Properties props) {
        if (props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("com.perforce.p4java.unsetClientName", "_____CLIENT_UNSET_____");
    }

    public String getProgramName() {
        if (this.programName != null) {
            return this.programName;
        }
        if (this.props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("programName", this.props.getProperty("com.perforce.p4java.programName", "Unknown P4Java program"));
    }

    public UsageOptions setProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public String getProgramVersion() {
        if (this.programVersion != null) {
            return this.programVersion;
        }
        if (this.props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("programVersion", this.props.getProperty("com.perforce.p4java.programVersion", PropertyDefs.PROG_VERSION_DEFAULT));
    }

    public UsageOptions setProgramVersion(String programVersion) {
        this.programVersion = programVersion;
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory != null ? this.workingDirectory : this.defaultWorkingDirectory;
    }

    public UsageOptions setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public UsageOptions setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getTextLanguage() {
        return this.textLanguage;
    }

    public UsageOptions setTextLanguage(String textLanguage) {
        this.textLanguage = textLanguage;
        return this;
    }

    public Properties getProps() {
        return this.props;
    }

    public UsageOptions setProps(Properties props) {
        this.props = props;
        return this;
    }

    public String getUnsetClientName() {
        if (this.unsetClientName != null) {
            return this.unsetClientName;
        }
        if (this.props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("com.perforce.p4java.unsetClientName", "_____CLIENT_UNSET_____");
    }

    public UsageOptions setUnsetClientName(String unsetClientName) {
        this.unsetClientName = unsetClientName;
        return this;
    }

    public String getUnsetUserName() {
        if (this.unsetUserName != null) {
            return this.unsetUserName;
        }
        if (this.props == null) {
            throw new NullPointerError("Null properties in UsageOptions");
        }
        return this.props.getProperty("com.perforce.p4java.unsetUserName", "nouser");
    }

    public UsageOptions setUnsetUserName(String unsetUserName) {
        this.unsetUserName = unsetUserName;
        return this;
    }
}

