/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class RpcSSLSocketFactory
extends SSLSocketFactory {
    private static RpcSSLSocketFactory sslSocketFactory = null;
    private SSLContext sslContext = null;
    private Properties properties = null;

    private RpcSSLSocketFactory(Properties properties) {
        this.properties = properties;
    }

    public static synchronized RpcSSLSocketFactory getInstance(Properties properties) {
        if (sslSocketFactory == null) {
            sslSocketFactory = new RpcSSLSocketFactory(properties);
        }
        return sslSocketFactory;
    }

    private SSLContext createSSLContext() {
        try {
            TrustManager[] trustManagerArray;
            if (this.properties == null) {
                this.properties = new Properties();
            }
            String protocol = RpcPropertyDefs.getProperty(this.properties, "secureSocketProtocol", "TLS");
            boolean trustAll = RpcPropertyDefs.getPropertyAsBoolean(this.properties, "secureSocketTrustAll", true);
            if (trustAll) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new TrustAllTrustManager();
            } else {
                trustManagerArray = null;
            }
            TrustManager[] trustManager = trustManagerArray;
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(null, trustManager, null);
            return context;
        }
        catch (NoSuchAlgorithmException e) {
            Log.error("Error occurred in RpcSSLSocketFactory constructor: " + e.getLocalizedMessage());
            Log.exception(e);
            throw new P4JavaError("Error occurred in RpcSSLSocketFactory constructor: " + e.getLocalizedMessage());
        }
        catch (KeyManagementException e) {
            Log.error("Error occurred in RpcSSLSocketFactory constructor: " + e.getLocalizedMessage());
            Log.exception(e);
            throw new P4JavaError("Error occurred in RpcSSLSocketFactory constructor: " + e.getLocalizedMessage());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslContext == null) {
            this.sslContext = this.createSSLContext();
        }
        return this.sslContext;
    }

    private Socket configureSSLSocket(Socket socket) {
        if (socket != null) {
            boolean setEnabledProtocols;
            if (this.properties == null) {
                this.properties = new Properties();
            }
            if (setEnabledProtocols = RpcPropertyDefs.getPropertyAsBoolean(this.properties, "secureSocketSetEnabledProptocols", true)) {
                String[] enabledProtocols = RpcPropertyDefs.getProperty(this.properties, "secureSocketEnabledProtocols", "TLSv1").split("\\s*,\\s*");
                ((SSLSocket)socket).setEnabledProtocols(enabledProtocols);
            }
        }
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose));
    }

    public Socket createSocket() throws IOException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket(host, port));
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket(host, port, localHost, localPort));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSSLSocket(this.getSSLContext().getSocketFactory().createSocket(address, port, localAddress, localPort));
    }

    public String[] getDefaultCipherSuites() {
        return this.getSSLContext().getSocketFactory().getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.getSSLContext().getSocketFactory().getSupportedCipherSuites();
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] acceptedIssuers = new X509Certificate[0];

        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return acceptedIssuers;
        }
    }
}

