/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.User;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IOptionsServer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreFactory {
    public static IClient createClient(IOptionsServer server, String name, String description, String root, String[] paths, boolean createOnServer) throws P4JavaException {
        Client client = Client.newClient(server, name, description, root, paths);
        if (client == null) {
            throw new NullPointerError("null client object returned from Client.newClient method");
        }
        if (!createOnServer) {
            return client;
        }
        String createString = server.createClient(client);
        return server.getClient(name);
    }

    public static IChangelist createChangelist(IClient client, String description, boolean createOnServer) throws P4JavaException {
        Changelist changelist = Changelist.newChangelist(client, description);
        if (!createOnServer) {
            return changelist;
        }
        return client.createChangelist(changelist);
    }

    public static IJob createJob(IOptionsServer server, Map<String, Object> map, boolean createOnServer) throws P4JavaException {
        if (!createOnServer) {
            return Job.newJob(server, map);
        }
        if (server == null) {
            throw new NullPointerError("null server passed to Factory.createJob()");
        }
        return server.createJob(map);
    }

    public static ILabel createLabel(IOptionsServer server, String name, String description, String[] mapping, boolean createOnServer) throws P4JavaException {
        Label label = Label.newLabel(server, name, description, mapping);
        if (!createOnServer) {
            return label;
        }
        server.createLabel(label);
        return server.getLabel(name);
    }

    public static IUser createUser(IOptionsServer server, String name, String email, String fullName, String password, boolean createOnServer) throws P4JavaException {
        User user = User.newUser(name, email, fullName, password);
        if (!createOnServer) {
            return user;
        }
        if (server == null) {
            throw new NullPointerException("null server passed to Factory.createUser()");
        }
        server.createUser((IUser)user, true);
        return server.getUser(name);
    }

    public static IUserGroup createUserGroup(IOptionsServer server, String name, List<String> users, boolean createOnServer) throws P4JavaException {
        UserGroup group = UserGroup.newUserGroup(name, users);
        if (!createOnServer) {
            return group;
        }
        if (server == null) {
            throw new NullPointerException("null server passed to Factory.createUserGroup()");
        }
        server.createUserGroup(group, null);
        return server.getUserGroup(name);
    }

    public static IBranchSpec newBranchSpec(IOptionsServer server, String name, String description, String[] branches, boolean createOnServer) throws P4JavaException {
        BranchSpec branchSpec = BranchSpec.newBranchSpec(server, name, description, branches);
        if (!createOnServer) {
            return branchSpec;
        }
        server.createBranchSpec(branchSpec);
        return server.getBranchSpec(name);
    }
}

