/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.charset;

import com.perforce.p4java.charset.PerforceShiftJISCharset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceCharsetProvider
extends CharsetProvider {
    private static final String CHARSET_NAME = "P4ShiftJIS";
    private Charset charset = new PerforceShiftJISCharset("P4ShiftJIS", new String[]{"P4-ShiftJIS", "p4shiftjis", "p4-shiftjis"});
    private static Map<String, Charset> charsetNameMap = new HashMap<String, Charset>();

    public PerforceCharsetProvider() {
        charsetNameMap.put(this.charset.name(), this.charset);
        Iterator<String> aliases = this.charset.aliases().iterator();
        while (aliases.hasNext()) {
            charsetNameMap.put(aliases.next(), this.charset);
        }
    }

    @Override
    public Charset charsetForName(String charsetName) {
        if (charsetNameMap.containsKey(charsetName)) {
            return this.charset;
        }
        return null;
    }

    @Override
    public Iterator<Charset> charsets() {
        HashSet<Charset> set = new HashSet<Charset>();
        set.add(this.charset);
        return set.iterator();
    }
}

