/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.cli;

import java.util.Arrays;

class Options {
    private final String[] params;
    private int index;
    private String lastOptionValue;
    private String lastOptionOriginalForm;

    public Options(String[] params) {
        this.params = (String[])params.clone();
    }

    public String nextOption() {
        if (this.index >= this.params.length) {
            return null;
        }
        String param = this.params[this.index];
        if (!param.startsWith("-")) {
            return null;
        }
        ++this.index;
        this.lastOptionOriginalForm = param;
        this.lastOptionValue = null;
        if (param.startsWith("--")) {
            if ("--".equals(param)) {
                return null;
            }
            int valueDelimiterIndex = param.indexOf(61);
            if (valueDelimiterIndex != -1) {
                this.lastOptionValue = param.substring(valueDelimiterIndex + 1);
                this.lastOptionOriginalForm = param.substring(0, valueDelimiterIndex);
                return param.substring("--".length(), valueDelimiterIndex);
            }
            return param.substring("--".length());
        }
        return param.substring("-".length());
    }

    public String getOptionOriginalForm() {
        return this.lastOptionOriginalForm;
    }

    public String getRequiredValue(String valueDescription) throws OptionsException {
        if (this.lastOptionValue != null) {
            String result = this.lastOptionValue;
            this.lastOptionValue = null;
            return result;
        }
        if (this.index >= this.params.length) {
            throw new OptionsException(valueDescription + " missing after " + this.lastOptionOriginalForm);
        }
        String param = this.params[this.index];
        if ("--".equals(param)) {
            throw new OptionsException(valueDescription + " missing after " + this.lastOptionOriginalForm);
        }
        ++this.index;
        return param;
    }

    public int getRequiredIntValue(String valueDescription) throws OptionsException {
        String value = this.getRequiredValue(valueDescription);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new OptionsException(valueDescription + " (" + this.lastOptionOriginalForm + ") must be a decimal number: " + value);
        }
    }

    public boolean getOptionalBooleanValue(boolean defaultValue) throws OptionsException {
        if (this.lastOptionValue != null) {
            String stringValue = this.lastOptionValue;
            this.lastOptionValue = null;
            if ("true".equals(stringValue)) {
                return true;
            }
            if ("false".equals(stringValue)) {
                return false;
            }
            throw new OptionsException("Unsupported value for " + this.lastOptionOriginalForm + ": " + stringValue + ". Only true or false supported.");
        }
        if (this.index >= this.params.length) {
            return defaultValue;
        }
        String stringValue = this.params[this.index];
        if ("true".equals(stringValue)) {
            ++this.index;
            return true;
        }
        if ("false".equals(stringValue)) {
            ++this.index;
            return false;
        }
        return defaultValue;
    }

    public String[] getRemainingParams() {
        if (this.index >= this.params.length) {
            return new String[0];
        }
        String param = this.params[this.index];
        if ("--".equals(param)) {
            return Arrays.copyOfRange(this.params, this.index + 1, this.params.length);
        }
        return Arrays.copyOfRange(this.params, this.index, this.params.length);
    }

    public static class OptionsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public OptionsException(String message) {
            super(message);
        }
    }
}

