/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.cli;

import com.mcxiaoke.packer.cli.Bridge;
import com.mcxiaoke.packer.cli.Helper;
import com.mcxiaoke.packer.cli.Options;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class Main {
    public static final String OUTPUT = "output";

    public static void main(String[] args) {
        if (args.length == 0 || "--help".equals(args[0]) || "-h".equals(args[0]) || "-v".equals(args[0]) || "--version".equals(args[0])) {
            Main.printUsage();
            return;
        }
        String cmd = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        try {
            if ("generate".equals(cmd)) {
                Main.generate(params);
            } else if ("verify".equals(cmd)) {
                Main.verify(params);
            } else if ("help".equals(cmd)) {
                Main.printUsage();
            } else if ("version".equals(cmd)) {
                Main.printUsage();
            } else {
                System.err.println("Unsupported command: " + cmd);
                Main.printUsage();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void printUsage() {
        Helper.printUsage();
    }

    private static void generate(String[] params) throws Exception {
        String name;
        if (params.length == 0) {
            Main.printUsage();
            return;
        }
        System.out.println("========== APK Packer ==========");
        Set<String> channels = null;
        File apkFile = null;
        File outputDir = null;
        Options optionsParser = new Options(params);
        String form = null;
        while ((name = optionsParser.nextOption()) != null) {
            String value;
            form = optionsParser.getOptionOriginalForm();
            if ("help".equals(name) || "h".equals(name)) {
                Main.printUsage();
                return;
            }
            if ("channels".equals(name) || "c".equals(name)) {
                value = optionsParser.getRequiredValue("Channels file(@) or list(,).");
                if (value.startsWith("@")) {
                    channels = Helper.parseChannels(new File(value.substring(1)));
                    continue;
                }
                channels = Helper.parseChannels(value);
                continue;
            }
            if ("input".equals(name) || "i".equals(name)) {
                value = optionsParser.getRequiredValue("Input APK file");
                apkFile = new File(value);
                continue;
            }
            if (OUTPUT.equals(name) || "o".equals(name)) {
                value = optionsParser.getRequiredValue("Output Directory");
                outputDir = new File(value);
                continue;
            }
            System.err.println("Unsupported option: " + form);
            Main.printUsage();
        }
        params = optionsParser.getRemainingParams();
        if (apkFile == null) {
            if (params.length < 1) {
                throw new Options.OptionsException("Missing Input APK");
            }
            apkFile = new File(params[0]);
        }
        if (outputDir == null) {
            outputDir = new File(OUTPUT);
        }
        Main.doGenerate(apkFile, channels, outputDir);
    }

    private static void doGenerate(File apkFile, Collection<String> channels, File outputDir) throws IOException {
        if (apkFile == null || !apkFile.exists() || !apkFile.isFile()) {
            throw new IOException("Invalid Input APK: " + apkFile);
        }
        if (!Bridge.verifyApk(apkFile)) {
            throw new IOException("Invalid Signature: " + apkFile);
        }
        if (outputDir.exists()) {
            Helper.deleteAPKs(outputDir);
        } else {
            outputDir.mkdirs();
        }
        System.out.println("Input: " + apkFile.getAbsolutePath());
        System.out.println("Output:" + outputDir.getAbsolutePath());
        System.out.println("Channels:" + Arrays.toString(channels.toArray()));
        String fileName = apkFile.getName();
        String baseName = Helper.getBaseName(fileName);
        String extName = Helper.getExtName(fileName);
        for (String channel : channels) {
            String apkName = String.format(Locale.US, "%s-%s.%s", baseName, channel, extName);
            File destFile = new File(outputDir, apkName);
            Helper.copyFile(apkFile, destFile);
            Bridge.writeChannel(destFile, channel);
            if (Bridge.verifyChannel(destFile, channel)) {
                System.out.println("Generating " + apkName);
                continue;
            }
            destFile.delete();
            throw new IOException("Failed to verify APK: " + apkName);
        }
    }

    private static void verify(String[] params) throws Exception {
        if (params.length == 0) {
            Main.printUsage();
            return;
        }
        System.out.println("========== APK Verify ==========");
        if (params.length < 1) {
            throw new IllegalArgumentException("Missing Input APK");
        }
        File apkFile = new File(params[0]);
        Main.doVerify(apkFile);
    }

    private static void doVerify(File apkFile) throws IOException {
        if (apkFile == null || !apkFile.exists() || !apkFile.isFile()) {
            throw new IOException("Invalid Input APK: " + apkFile);
        }
        boolean verified = Bridge.verifyApk(apkFile);
        String channel = Bridge.readChannel(apkFile);
        System.out.println("File: " + apkFile.getName());
        System.out.println("Signed: " + verified);
        System.out.println("Channel: " + channel);
    }
}

