/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.cli;

import com.mcxiaoke.packer.cli.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class Helper {
    public static Set<String> readChannels(String value) throws IOException {
        if (value.startsWith("@")) {
            return Helper.parseChannels(new File(value.substring(1)));
        }
        return Helper.parseChannels(value);
    }

    public static Set<String> parseChannels(File file) throws IOException {
        String line;
        ArrayList<String> channels = new ArrayList<String>();
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            String ch;
            String[] parts = line.split("#");
            if (parts.length <= 0 || (ch = parts[0].trim()).length() <= 0) continue;
            channels.add(ch);
        }
        br.close();
        fr.close();
        return Helper.escape(channels);
    }

    public static Set<String> parseChannels(String text) {
        String[] lines = text.split(",");
        ArrayList<String> channels = new ArrayList<String>();
        for (String line : lines) {
            String ch = line.trim();
            if (ch.length() <= 0) continue;
            channels.add(ch);
        }
        return Helper.escape(channels);
    }

    public static Set<String> escape(Collection<String> cs) {
        Pattern p = Pattern.compile("[\\\\/:*?\"'<>|]");
        HashSet<String> set = new HashSet<String>();
        for (String s : cs) {
            set.add(p.matcher(s).replaceAll("_"));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dest).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void deleteAPKs(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".apk");
            }
        };
        File[] files = dir.listFiles(filter);
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    public static String getExtName(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot > 0) {
            return fileName.substring(dot + 1);
        }
        return null;
    }

    public static String getBaseName(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot > 0) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }

    public static void printUsage() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("help.txt"), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read help resource");
        }
    }
}

