/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.cli;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.mcxiaoke.packer.common.PackerCommon;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class Bridge {
    public static void writeChannel(File file, String channel) throws IOException {
        PackerCommon.writeChannel((File)file, (String)channel);
    }

    public static String readChannel(File file) throws IOException {
        return PackerCommon.readChannel((File)file);
    }

    public static boolean verifyChannel(File file, String channel) throws IOException {
        return Bridge.verifyApk(file) && channel.equals(Bridge.readChannel(file));
    }

    public static boolean verifyApk(File file) throws IOException {
        ApkVerifier verifier = new ApkVerifier.Builder(file).build();
        try {
            ApkVerifier.Result result = verifier.verify();
            return result.isVerified() && result.isVerifiedUsingV1Scheme() && result.isVerifiedUsingV2Scheme();
        }
        catch (ApkFormatException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

