/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.X509ObjectIdentifiers;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import org.spongycastle.pqc.crypto.mceliece.McEliecePKCSCipher;
import org.spongycastle.pqc.jcajce.provider.mceliece.McElieceKeysToParams;
import org.spongycastle.pqc.jcajce.provider.util.AsymmetricBlockCipher;

public class McEliecePKCSCipherSpi
extends AsymmetricBlockCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private McEliecePKCSCipher cipher;

    public McEliecePKCSCipherSpi(Digest digest, McEliecePKCSCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key);
        param = new ParametersWithRandom((CipherParameters)param, sr);
        this.digest.reset();
        this.cipher.init(true, (CipherParameters)param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.digest.reset();
        this.cipher.init(false, (CipherParameters)param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected byte[] messageEncrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageEncrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    protected byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageDecrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public String getName() {
        return "McEliecePKCS";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceKeyParameters mcElieceKeyParameters = key instanceof PublicKey ? (McElieceKeyParameters)McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceKeyParameters)McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.cipher.getKeySize(mcElieceKeyParameters);
    }

    public static class McEliecePKCS512
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS512() {
            super((Digest)new SHA512Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS384
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS384() {
            super((Digest)new SHA384Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS256
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS256() {
            super((Digest)new SHA256Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS224
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS224() {
            super((Digest)new SHA224Digest(), new McEliecePKCSCipher());
        }
    }

    public static class McEliecePKCS
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS() {
            super((Digest)new SHA1Digest(), new McEliecePKCSCipher());
        }
    }
}

