/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.prf;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.prf.PrfSet;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class PrfSetWrapper
implements PrimitiveWrapper<PrfSet> {
    @Override
    public PrfSet wrap(PrimitiveSet<PrfSet> set) throws GeneralSecurityException {
        return new WrappedPrfSet(set);
    }

    @Override
    public Class<PrfSet> getPrimitiveClass() {
        return PrfSet.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(new PrfSetWrapper());
    }

    private static class WrappedPrfSet
    extends PrfSet {
        private final Map<Integer, Prf> keyIdToPrfMap;
        private final int primaryKeyId;

        private WrappedPrfSet(PrimitiveSet<PrfSet> primitives) throws GeneralSecurityException {
            if (primitives.getRawPrimitives().isEmpty()) {
                throw new GeneralSecurityException("No primitives provided.");
            }
            if (primitives.getPrimary() == null) {
                throw new GeneralSecurityException("Primary key not set.");
            }
            this.primaryKeyId = primitives.getPrimary().getKeyId();
            List<PrimitiveSet.Entry<PrfSet>> entries = primitives.getRawPrimitives();
            HashMap<Integer, Prf> mutablePrfMap = new HashMap<Integer, Prf>();
            for (PrimitiveSet.Entry<PrfSet> entry : entries) {
                if (!entry.getOutputPrefixType().equals(OutputPrefixType.RAW)) {
                    throw new GeneralSecurityException("Key " + entry.getKeyId() + " has non raw prefix type");
                }
                if (entry.getPrimitive().getPrfs().size() > 1) {
                    throw new GeneralSecurityException("More PRFs than expected in KeyTypeManager for key " + entry.getKeyId());
                }
                mutablePrfMap.put(entry.getKeyId(), entry.getPrimitive().getPrfs().get(entry.getPrimitive().getPrimaryId()));
            }
            this.keyIdToPrfMap = Collections.unmodifiableMap(mutablePrfMap);
        }

        @Override
        public int getPrimaryId() {
            return this.primaryKeyId;
        }

        @Override
        public Map<Integer, Prf> getPrfs() throws GeneralSecurityException {
            return this.keyIdToPrfMap;
        }
    }
}

