/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.play.tasks.internal;

import com.github.triplet.gradle.androidpublisher.EditManager;
import com.github.triplet.gradle.androidpublisher.EditResponse;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.common.utils.IoKt;
import com.github.triplet.gradle.play.internal.ExtensionsKt;
import com.github.triplet.gradle.play.internal.PlayExtensionConfig;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001cR\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService;", "Lorg/gradle/api/services/BuildService;", "Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService$Params;", "fileOps", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/FileSystemOperations;)V", "editId", "", "getEditId", "()Ljava/lang/String;", "editIdFile", "Ljava/io/File;", "editIdFileAndFriends", "", "getEditIdFileAndFriends", "()Ljava/util/List;", "edits", "Lcom/github/triplet/gradle/androidpublisher/EditManager;", "getEdits", "()Lcom/github/triplet/gradle/androidpublisher/EditManager;", "edits$delegate", "Lkotlin/Lazy;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "getPublisher", "()Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "publisher$delegate", "cleanup", "", "commit", "getOrCreateEditId", "handleFailure", "response", "Lcom/github/triplet/gradle/androidpublisher/EditResponse$Failure;", "scheduleCommit", "shouldCommit", "", "shouldSkip", "skipCommit", "validate", "Params", "plugin"})
public abstract class PlayApiService
implements BuildService<Params> {
    @NotNull
    private final Lazy publisher$delegate;
    @NotNull
    private final Lazy edits$delegate;
    private final File editIdFile;
    private final FileSystemOperations fileOps;

    @NotNull
    public final PlayPublisher getPublisher() {
        Lazy lazy = this.publisher$delegate;
        PlayApiService playApiService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PlayPublisher)lazy.getValue();
    }

    @NotNull
    public final EditManager getEdits() {
        Lazy lazy = this.edits$delegate;
        PlayApiService playApiService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EditManager)lazy.getValue();
    }

    private final String getEditId() {
        return FilesKt.readText$default((File)this.editIdFile, null, (int)1, null);
    }

    private final List<File> getEditIdFileAndFriends() {
        return CollectionsKt.listOf((Object[])new File[]{this.editIdFile, IoKt.marked((File)this.editIdFile, (String)"commit"), IoKt.marked((File)this.editIdFile, (String)"skipped")});
    }

    public final void scheduleCommit() {
        IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"commit"));
    }

    public final boolean shouldCommit() {
        return IoKt.marked((File)this.editIdFile, (String)"commit").exists();
    }

    public final void commit() {
        this.getPublisher().commitEdit(this.getEditId());
    }

    public final void skipCommit() {
        IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"skipped"));
    }

    public final boolean shouldSkip() {
        return IoKt.marked((File)this.editIdFile, (String)"skipped").exists();
    }

    public final void validate() {
        this.getPublisher().validateEdit(this.getEditId());
    }

    public final void cleanup() {
        this.fileOps.delete((Action)new Action<DeleteSpec>(this){
            final /* synthetic */ PlayApiService this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkParameterIsNotNull((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{PlayApiService.access$getEditIdFileAndFriends$p(this.this$0)});
            }
            {
                this.this$0 = playApiService;
            }
        });
    }

    private final String getOrCreateEditId() {
        String string;
        EditResponse response;
        EditResponse editResponse;
        String string2;
        File file = IoKt.orNull((File)this.editIdFile);
        String string3 = IoKt.nullOrFull(file != null ? FilesKt.readText$default((File)file, null, (int)1, null) : null);
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string2 = IoKt.marked((File)this.editIdFile, (String)"skipped").exists() ? string4 : null;
        } else {
            string2 = null;
        }
        String editId = string2;
        this.cleanup();
        if (editId == null) {
            editResponse = this.getPublisher().insertEdit();
        } else {
            IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"skipped"));
            editResponse = this.getPublisher().getEdit(editId);
        }
        EditResponse editResponse2 = response = editResponse;
        if (editResponse2 instanceof EditResponse.Success) {
            string = ((EditResponse.Success)response).getId();
        } else if (editResponse2 instanceof EditResponse.Failure) {
            string = this.handleFailure((EditResponse.Failure)response);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String handleFailure(EditResponse.Failure response) {
        Property<String> appId = ((Params)this.getParameters()).getAppId();
        if (response.isNewApp()) {
            Void void_ = response.rethrow(StringsKt.trimMargin$default((String)("\n                    |No application found for the package name '" + appId + "'. The first version of your\n                    |app must be uploaded via the Play Console.\n                "), null, (int)1, null));
            throw null;
        }
        if (response.isInvalidEdit()) {
            Logging.getLogger(PlayApiService.class).error("Failed to retrieve saved edit, regenerating.");
            return this.getOrCreateEditId();
        }
        if (response.isUnauthorized()) {
            Void void_ = response.rethrow("Service account not authenticated. See the README for instructions:\nhttps://github.com/Triple-T/gradle-play-publisher#service-account");
            throw null;
        }
        Void void_ = response.rethrow();
        throw null;
    }

    @Inject
    public PlayApiService(@NotNull FileSystemOperations fileOps) {
        Intrinsics.checkParameterIsNotNull((Object)fileOps, (String)"fileOps");
        this.fileOps = fileOps;
        this.publisher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PlayPublisher>(this){
            final /* synthetic */ PlayApiService this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final PlayPublisher invoke() {
                PlayPublisher playPublisher;
                Object object = ((Params)this.this$0.getParameters()).getConfig().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.config.get()");
                Closeable closeable = ExtensionsKt.credentialStream((PlayExtensionConfig)object);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Object object2 = ((Params)this.this$0.getParameters()).getAppId().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.appId.get()");
                    playPublisher = PlayPublisher.Companion.invoke(it, (String)object2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return playPublisher;
            }
            {
                this.this$0 = playApiService;
                super(0);
            }
        }));
        this.edits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EditManager>(this){
            final /* synthetic */ PlayApiService this$0;

            @NotNull
            public final EditManager invoke() {
                String editId = PlayApiService.access$getOrCreateEditId(this.this$0);
                FilesKt.writeText$default((File)IoKt.safeCreateNewFile((File)PlayApiService.access$getEditIdFile$p(this.this$0)), (String)editId, null, (int)2, null);
                return EditManager.Companion.invoke(this.this$0.getPublisher(), editId);
            }
            {
                this.this$0 = playApiService;
                super(0);
            }
        }));
        Object object = ((Params)this.getParameters()).getEditIdFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.editIdFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parameters.editIdFile.get().asFile");
        this.editIdFile = file;
    }

    public static final /* synthetic */ List access$getEditIdFileAndFriends$p(PlayApiService $this) {
        return $this.getEditIdFileAndFriends();
    }

    public static final /* synthetic */ String access$getOrCreateEditId(PlayApiService $this) {
        return $this.getOrCreateEditId();
    }

    public static final /* synthetic */ File access$getEditIdFile$p(PlayApiService $this) {
        return $this.editIdFile;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "appId", "Lorg/gradle/api/provider/Property;", "", "getAppId", "()Lorg/gradle/api/provider/Property;", "config", "Lcom/github/triplet/gradle/play/internal/PlayExtensionConfig;", "getConfig", "editIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getEditIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<PlayExtensionConfig> getConfig();

        @NotNull
        public Property<String> getAppId();

        @NotNull
        public RegularFileProperty getEditIdFile();
    }
}

