/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.util.Log;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import com.facebook.imagepipeline.debug.CloseableReferenceLeakTracker;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.PropagatesNullable;
import java.io.Closeable;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class CloseableReferenceFactory {
    private final CloseableReference.LeakHandler mLeakHandler;

    public CloseableReferenceFactory(final CloseableReferenceLeakTracker closeableReferenceLeakTracker) {
        this.mLeakHandler = new CloseableReference.LeakHandler(){

            public void reportLeak(SharedReference<Object> reference, @Nullable Throwable stacktrace) {
                closeableReferenceLeakTracker.trackCloseableReferenceLeak(reference, stacktrace);
                Object value = reference.get();
                String name = value != null ? value.getClass().getName() : "<value is null>";
                FLog.w((String)"Fresco", (String)"Finalized without closing: %x %x (type = %s).\nStack:\n%s", (Object[])new Object[]{System.identityHashCode(this), System.identityHashCode(reference), name, CloseableReferenceFactory.getStackTraceString(stacktrace)});
            }

            public boolean requiresStacktrace() {
                return closeableReferenceLeakTracker.isSet();
            }
        };
    }

    public <U extends Closeable> CloseableReference<U> create(@Nullable @PropagatesNullable U u) {
        return CloseableReference.of(u, (CloseableReference.LeakHandler)this.mLeakHandler);
    }

    public <T> CloseableReference<T> create(T t, ResourceReleaser<T> resourceReleaser) {
        return CloseableReference.of(t, resourceReleaser, (CloseableReference.LeakHandler)this.mLeakHandler);
    }

    private static String getStackTraceString(@Nullable Throwable tr) {
        if (tr == null) {
            return "";
        }
        String stackTrace = Log.getStackTraceString((Throwable)tr);
        return stackTrace;
    }
}

