/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.common.util.HashCodeUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u0005J\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016J\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/imagepipeline/common/RotationOptions;", "", "rotation", "", "deferUntilRendered", "", "(IZ)V", "forcedAngle", "getForcedAngle", "()I", "canDeferUntilRendered", "equals", "other", "hashCode", "rotationEnabled", "toString", "", "useImageMetadata", "Companion", "Rotation", "RotationAngle", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nRotationOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RotationOptions.kt\ncom/facebook/imagepipeline/common/RotationOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class RotationOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int rotation;
    private final boolean deferUntilRendered;
    public static final int NO_ROTATION = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    private static final int USE_EXIF_ROTATION_ANGLE = -1;
    private static final int DISABLE_ROTATION = -2;
    @NotNull
    private static final RotationOptions ROTATION_OPTIONS_AUTO_ROTATE = new RotationOptions(-1, false);
    @NotNull
    private static final RotationOptions ROTATION_OPTIONS_DISABLE_ROTATION = new RotationOptions(-2, false);
    @NotNull
    private static final RotationOptions ROTATION_OPTIONS_ROTATE_AT_RENDER_TIME = new RotationOptions(-1, true);

    private RotationOptions(int rotation, boolean deferUntilRendered) {
        this.rotation = rotation;
        this.deferUntilRendered = deferUntilRendered;
    }

    public final boolean useImageMetadata() {
        return this.rotation == -1;
    }

    public final boolean rotationEnabled() {
        return this.rotation != -2;
    }

    public final int getForcedAngle() {
        if (!(!this.useImageMetadata())) {
            boolean bl = false;
            String string = "Rotation is set to use EXIF";
            throw new IllegalStateException(string.toString());
        }
        return this.rotation;
    }

    public final boolean canDeferUntilRendered() {
        return this.deferUntilRendered;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((Object)this.rotation, (Object)this.deferUntilRendered);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RotationOptions)) {
            return false;
        }
        Object that = other;
        return this.rotation == ((RotationOptions)that).rotation && this.deferUntilRendered == ((RotationOptions)that).deferUntilRendered;
    }

    @NotNull
    public String toString() {
        Locale locale = null;
        String string = "%d defer:%b";
        Object[] objectArray = new Object[]{this.rotation, this.deferUntilRendered};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final RotationOptions autoRotate() {
        return Companion.autoRotate();
    }

    @JvmStatic
    @NotNull
    public static final RotationOptions disableRotation() {
        return Companion.disableRotation();
    }

    @JvmStatic
    @NotNull
    public static final RotationOptions autoRotateAtRenderTime() {
        return Companion.autoRotateAtRenderTime();
    }

    @JvmStatic
    @NotNull
    public static final RotationOptions forceRotation(int angle) {
        return Companion.forceRotation(angle);
    }

    public /* synthetic */ RotationOptions(int rotation, boolean deferUntilRendered, DefaultConstructorMarker $constructor_marker) {
        this(rotation, deferUntilRendered);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\b\u0010\u0010\u001a\u00020\nH\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/common/RotationOptions$Companion;", "", "()V", "DISABLE_ROTATION", "", "NO_ROTATION", "ROTATE_180", "ROTATE_270", "ROTATE_90", "ROTATION_OPTIONS_AUTO_ROTATE", "Lcom/facebook/imagepipeline/common/RotationOptions;", "ROTATION_OPTIONS_DISABLE_ROTATION", "ROTATION_OPTIONS_ROTATE_AT_RENDER_TIME", "USE_EXIF_ROTATION_ANGLE", "autoRotate", "autoRotateAtRenderTime", "disableRotation", "forceRotation", "angle", "imagepipeline-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RotationOptions autoRotate() {
            return ROTATION_OPTIONS_AUTO_ROTATE;
        }

        @JvmStatic
        @NotNull
        public final RotationOptions disableRotation() {
            return ROTATION_OPTIONS_DISABLE_ROTATION;
        }

        @JvmStatic
        @NotNull
        public final RotationOptions autoRotateAtRenderTime() {
            return ROTATION_OPTIONS_ROTATE_AT_RENDER_TIME;
        }

        @JvmStatic
        @NotNull
        public final RotationOptions forceRotation(int angle) {
            return new RotationOptions(angle, false, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/facebook/imagepipeline/common/RotationOptions$Rotation;", "", "imagepipeline-base_release"})
    private static @interface Rotation {
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/facebook/imagepipeline/common/RotationOptions$RotationAngle;", "", "imagepipeline-base_release"})
    public static @interface RotationAngle {
    }
}

