/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.facebook.cache.common.HasDebugData;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.internal.Supplier;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.cache.ValueDescriptor;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.STRICT)
public class LruCountingMemoryCache<K, V>
implements CountingMemoryCache<K, V>,
MemoryCache<K, V>,
HasDebugData {
    @Nullable
    private final CountingMemoryCache.EntryStateObserver<K> mEntryStateObserver;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, CountingMemoryCache.Entry<K, V>> mExclusiveEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, CountingMemoryCache.Entry<K, V>> mCachedEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<Bitmap, Object> mOtherEntries = new WeakHashMap<Bitmap, Object>();
    private final ValueDescriptor<V> mValueDescriptor;
    private final MemoryCache.CacheTrimStrategy mCacheTrimStrategy;
    private final Supplier<MemoryCacheParams> mMemoryCacheParamsSupplier;
    @GuardedBy(value="this")
    protected MemoryCacheParams mMemoryCacheParams;
    @GuardedBy(value="this")
    private long mLastCacheParamsCheck;
    private final boolean mStoreEntrySize;
    private final boolean mIgnoreSizeMismatch;

    public LruCountingMemoryCache(ValueDescriptor<V> valueDescriptor, MemoryCache.CacheTrimStrategy cacheTrimStrategy, Supplier<MemoryCacheParams> memoryCacheParamsSupplier, @Nullable CountingMemoryCache.EntryStateObserver<K> entryStateObserver, boolean storeEntrySize, boolean ignoreSizeMismatch) {
        this.mValueDescriptor = valueDescriptor;
        this.mExclusiveEntries = new CountingLruMap<K, CountingMemoryCache.Entry<K, CountingMemoryCache.Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCachedEntries = new CountingLruMap<K, CountingMemoryCache.Entry<K, CountingMemoryCache.Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCacheTrimStrategy = cacheTrimStrategy;
        this.mMemoryCacheParamsSupplier = memoryCacheParamsSupplier;
        this.mMemoryCacheParams = (MemoryCacheParams)Preconditions.checkNotNull((Object)((MemoryCacheParams)this.mMemoryCacheParamsSupplier.get()), (Object)"mMemoryCacheParamsSupplier returned null");
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mEntryStateObserver = entryStateObserver;
        this.mStoreEntrySize = storeEntrySize;
        this.mIgnoreSizeMismatch = ignoreSizeMismatch;
    }

    private ValueDescriptor<CountingMemoryCache.Entry<K, V>> wrapValueDescriptor(final ValueDescriptor<V> evictableValueDescriptor) {
        return new ValueDescriptor<CountingMemoryCache.Entry<K, V>>(){

            @Override
            public int getSizeInBytes(CountingMemoryCache.Entry<K, V> entry) {
                if (LruCountingMemoryCache.this.mStoreEntrySize) {
                    return entry.size;
                }
                return evictableValueDescriptor.getSizeInBytes(entry.valueRef.get());
            }
        };
    }

    @Override
    @Nullable
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef) {
        return this.cache(key, valueRef, this.mEntryStateObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef, @Nullable CountingMemoryCache.EntryStateObserver<K> observer) {
        CountingMemoryCache.Entry<K, V> oldExclusive;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(valueRef);
        this.maybeUpdateCacheParams();
        CloseableReference<V> oldRefToClose = null;
        CloseableReference<V> clientRef = null;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            Object value;
            int size;
            oldExclusive = this.mExclusiveEntries.remove(key);
            CountingMemoryCache.Entry<K, V> oldEntry = this.mCachedEntries.remove(key);
            if (oldEntry != null) {
                this.makeOrphan(oldEntry);
                oldRefToClose = this.referenceToClose(oldEntry);
            }
            if (this.canCacheNewValueOfSize(size = this.mValueDescriptor.getSizeInBytes(value = valueRef.get()))) {
                CountingMemoryCache.Entry<K, V> newEntry = this.mStoreEntrySize ? CountingMemoryCache.Entry.of(key, valueRef, size, observer) : CountingMemoryCache.Entry.of(key, valueRef, observer);
                this.mCachedEntries.put(key, newEntry);
                clientRef = this.newClientReference(newEntry);
            }
        }
        CloseableReference.closeSafely(oldRefToClose);
        LruCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        this.maybeEvictEntries();
        return clientRef;
    }

    private synchronized boolean canCacheNewValueOfSize(int newValueSize) {
        return newValueSize <= this.mMemoryCacheParams.maxCacheEntrySize && this.getInUseCount() <= this.mMemoryCacheParams.maxCacheEntries - 1 && this.getInUseSizeInBytes() <= this.mMemoryCacheParams.maxCacheSize - newValueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> get(K key) {
        CountingMemoryCache.Entry<K, V> oldExclusive;
        Preconditions.checkNotNull(key);
        CloseableReference<V> clientRef = null;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            oldExclusive = this.mExclusiveEntries.remove(key);
            CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.get(key);
            if (entry != null) {
                clientRef = this.newClientReference(entry);
            }
        }
        LruCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return clientRef;
    }

    @Override
    @Nullable
    public synchronized V inspect(K key) {
        CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.get(key);
        if (entry == null) {
            return null;
        }
        return (V)entry.valueRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void probe(K key) {
        Preconditions.checkNotNull(key);
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            CountingMemoryCache.Entry<K, V> oldExclusive = this.mExclusiveEntries.remove(key);
            if (oldExclusive != null) {
                this.mExclusiveEntries.put(key, oldExclusive);
            }
        }
    }

    private synchronized CloseableReference<V> newClientReference(final CountingMemoryCache.Entry<K, V> entry) {
        this.increaseClientCount(entry);
        return CloseableReference.of((Object)entry.valueRef.get(), (ResourceReleaser)new ResourceReleaser<V>(){

            public void release(V unused) {
                LruCountingMemoryCache.this.releaseClientReference(entry);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseClientReference(CountingMemoryCache.Entry<K, V> entry) {
        CloseableReference<V> oldRefToClose;
        boolean isExclusiveAdded;
        Preconditions.checkNotNull(entry);
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            this.decreaseClientCount(entry);
            isExclusiveAdded = this.maybeAddToExclusives(entry);
            oldRefToClose = this.referenceToClose(entry);
        }
        CloseableReference.closeSafely(oldRefToClose);
        LruCountingMemoryCache.maybeNotifyExclusiveEntryInsertion(isExclusiveAdded ? entry : null);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized boolean maybeAddToExclusives(CountingMemoryCache.Entry<K, V> entry) {
        if (!entry.isOrphan && entry.clientCount == 0) {
            this.mExclusiveEntries.put(entry.key, entry);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> reuse(K key) {
        Preconditions.checkNotNull(key);
        CloseableReference clientRef = null;
        boolean removed = false;
        CountingMemoryCache.Entry<K, V> oldExclusive = null;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            oldExclusive = this.mExclusiveEntries.remove(key);
            if (oldExclusive != null) {
                CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.remove(key);
                Preconditions.checkNotNull(entry);
                Preconditions.checkState((entry.clientCount == 0 ? 1 : 0) != 0);
                clientRef = entry.valueRef;
                removed = true;
            }
        }
        if (removed) {
            LruCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        }
        return clientRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(Predicate<K> predicate) {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldExclusives;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            oldExclusives = this.mExclusiveEntries.removeAll(predicate);
            oldEntries = this.mCachedEntries.removeAll(predicate);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldExclusives);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return oldEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldExclusives;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            oldExclusives = this.mExclusiveEntries.clear();
            oldEntries = this.mCachedEntries.clear();
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldExclusives);
        this.maybeUpdateCacheParams();
    }

    @Override
    public synchronized boolean contains(Predicate<K> predicate) {
        return !this.mCachedEntries.getMatchingEntries(predicate).isEmpty();
    }

    @Override
    public synchronized boolean contains(K key) {
        return this.mCachedEntries.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(MemoryTrimType trimType) {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        double trimRatio = this.mCacheTrimStrategy.getTrimRatio(trimType);
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            int targetCacheSize = (int)((double)this.mCachedEntries.getSizeInBytes() * (1.0 - trimRatio));
            int targetEvictionQueueSize = Math.max(0, targetCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(Integer.MAX_VALUE, targetEvictionQueueSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldEntries);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized void maybeUpdateCacheParams() {
        if (this.mLastCacheParamsCheck + this.mMemoryCacheParams.paramsCheckIntervalMs > SystemClock.uptimeMillis()) {
            return;
        }
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mMemoryCacheParams = (MemoryCacheParams)Preconditions.checkNotNull((Object)((MemoryCacheParams)this.mMemoryCacheParamsSupplier.get()), (Object)"mMemoryCacheParamsSupplier returned null");
    }

    @Override
    public MemoryCacheParams getMemoryCacheParams() {
        return this.mMemoryCacheParams;
    }

    @Override
    public CountingLruMap<K, CountingMemoryCache.Entry<K, V>> getCachedEntries() {
        return this.mCachedEntries;
    }

    @Override
    public Map<Bitmap, Object> getOtherEntries() {
        return this.mOtherEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeEvictEntries() {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        LruCountingMemoryCache lruCountingMemoryCache = this;
        synchronized (lruCountingMemoryCache) {
            int maxCount = Math.min(this.mMemoryCacheParams.maxEvictionQueueEntries, this.mMemoryCacheParams.maxCacheEntries - this.getInUseCount());
            int maxSize = Math.min(this.mMemoryCacheParams.maxEvictionQueueSize, this.mMemoryCacheParams.maxCacheSize - this.getInUseSizeInBytes());
            oldEntries = this.trimExclusivelyOwnedEntries(maxCount, maxSize);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntryRemoval(oldEntries);
    }

    @Nullable
    private synchronized ArrayList<CountingMemoryCache.Entry<K, V>> trimExclusivelyOwnedEntries(int count, int size) {
        count = Math.max(count, 0);
        size = Math.max(size, 0);
        if (this.mExclusiveEntries.getCount() <= count && this.mExclusiveEntries.getSizeInBytes() <= size) {
            return null;
        }
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries = new ArrayList<CountingMemoryCache.Entry<K, V>>();
        while (this.mExclusiveEntries.getCount() > count || this.mExclusiveEntries.getSizeInBytes() > size) {
            K key = this.mExclusiveEntries.getFirstKey();
            if (key == null) {
                if (this.mIgnoreSizeMismatch) {
                    this.mExclusiveEntries.resetSize();
                    break;
                }
                throw new IllegalStateException(String.format("key is null, but exclusiveEntries count: %d, size: %d", this.mExclusiveEntries.getCount(), this.mExclusiveEntries.getSizeInBytes()));
            }
            this.mExclusiveEntries.remove(key);
            oldEntries.add(this.mCachedEntries.remove(key));
        }
        return oldEntries;
    }

    private void maybeClose(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (CountingMemoryCache.Entry<K, V> oldEntry : oldEntries) {
                CloseableReference.closeSafely(this.referenceToClose(oldEntry));
            }
        }
    }

    private void maybeNotifyExclusiveEntryRemoval(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> entries) {
        if (entries != null) {
            for (CountingMemoryCache.Entry<K, V> entry : entries) {
                LruCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(entry);
            }
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryRemoval(@Nullable CountingMemoryCache.Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, false);
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryInsertion(@Nullable CountingMemoryCache.Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, true);
        }
    }

    private synchronized void makeOrphans(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (CountingMemoryCache.Entry<K, V> oldEntry : oldEntries) {
                this.makeOrphan(oldEntry);
            }
        }
    }

    private synchronized void makeOrphan(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        entry.isOrphan = true;
    }

    private synchronized void increaseClientCount(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        ++entry.clientCount;
    }

    private synchronized void decreaseClientCount(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((entry.clientCount > 0 ? 1 : 0) != 0);
        --entry.clientCount;
    }

    @Nullable
    private synchronized CloseableReference<V> referenceToClose(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return entry.isOrphan && entry.clientCount == 0 ? entry.valueRef : null;
    }

    @Override
    public synchronized int getCount() {
        return this.mCachedEntries.getCount();
    }

    @Override
    public synchronized int getSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes();
    }

    public synchronized int getInUseCount() {
        return this.mCachedEntries.getCount() - this.mExclusiveEntries.getCount();
    }

    @Override
    public synchronized int getInUseSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes() - this.mExclusiveEntries.getSizeInBytes();
    }

    @Override
    public synchronized int getEvictionQueueCount() {
        return this.mExclusiveEntries.getCount();
    }

    @Override
    public synchronized int getEvictionQueueSizeInBytes() {
        return this.mExclusiveEntries.getSizeInBytes();
    }

    @Override
    @Nullable
    public synchronized String getDebugData() {
        return Objects.toStringHelper((String)"CountingMemoryCache").add("cached_entries_count", this.mCachedEntries.getCount()).add("cached_entries_size_bytes", this.mCachedEntries.getSizeInBytes()).add("exclusive_entries_count", this.mExclusiveEntries.getCount()).add("exclusive_entries_size_bytes", this.mExclusiveEntries.getSizeInBytes()).toString();
    }
}

